<?php

namespace EnumType;

/**
 * This class stands for wechselkennzeichenArt EnumType
 * @subpackage Enumerations
 */
class WechselkennzeichenArt
{
    /**
     * Constant for value 'Neues Fahrzeug als WKZ in bestehenden Vertrag einbündeln'
     * @return string 'Neues Fahrzeug als WKZ in bestehenden Vertrag einbündeln'
     */
    const VALUE_NEUES_FAHRZEUG_ALS_WKZ_IN_BESTEHENDEN_VERTRAG_EINB_ÜNDELN = 'Neues Fahrzeug als WKZ in bestehenden Vertrag einbündeln';
    /**
     * Constant for value 'Fahrzeugwechsel im bestehenden WKZ-Vertrag'
     * @return string 'Fahrzeugwechsel im bestehenden WKZ-Vertrag'
     */
    const VALUE_FAHRZEUGWECHSEL_IM_BESTEHENDEN_WKZ_VERTRAG = 'Fahrzeugwechsel im bestehenden WKZ-Vertrag';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NEUES_FAHRZEUG_ALS_WKZ_IN_BESTEHENDEN_VERTRAG_EINB_ÜNDELN
     * @uses self::VALUE_FAHRZEUGWECHSEL_IM_BESTEHENDEN_WKZ_VERTRAG
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NEUES_FAHRZEUG_ALS_WKZ_IN_BESTEHENDEN_VERTRAG_EINB_ÜNDELN,
            self::VALUE_FAHRZEUGWECHSEL_IM_BESTEHENDEN_WKZ_VERTRAG,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
