<?php

namespace EnumType;

/**
 * This class stands for vertriebsArtType EnumType
 * @subpackage Enumerations
 */
class VertriebsArtType
{
    /**
     * Constant for value 'Versicherungsmakler'
     * @return string 'Versicherungsmakler'
     */
    const VALUE_VERSICHERUNGSMAKLER = 'Versicherungsmakler';
    /**
     * Constant for value 'Mehrfachagent'
     * @return string 'Mehrfachagent'
     */
    const VALUE_MEHRFACHAGENT = 'Mehrfachagent';
    /**
     * Constant for value 'Eigener Vertrieb'
     * @return string 'Eigener Vertrieb'
     */
    const VALUE_EIGENER_VERTRIEB = 'Eigener Vertrieb';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_VERSICHERUNGSMAKLER
     * @uses self::VALUE_MEHRFACHAGENT
     * @uses self::VALUE_EIGENER_VERTRIEB
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_VERSICHERUNGSMAKLER,
            self::VALUE_MEHRFACHAGENT,
            self::VALUE_EIGENER_VERTRIEB,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
