<?php

namespace EnumType;

/**
 * This class stands for vbArtType EnumType
 * @subpackage Enumerations
 */
class VbArtType
{
    /**
     * Constant for value 'keine'
     * @return string 'keine'
     */
    const VALUE_KEINE = 'keine';
    /**
     * Constant for value 'VB ohne vorläufige Deckung'
     * @return string 'VB ohne vorläufige Deckung'
     */
    const VALUE_VB_OHNE_VORL_ÄUFIGE_DECKUNG = 'VB ohne vorläufige Deckung';
    /**
     * Constant for value 'VB mit vorläufiger Deckung'
     * @return string 'VB mit vorläufiger Deckung'
     */
    const VALUE_VB_MIT_VORL_ÄUFIGER_DECKUNG = 'VB mit vorläufiger Deckung';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KEINE
     * @uses self::VALUE_VB_OHNE_VORL_ÄUFIGE_DECKUNG
     * @uses self::VALUE_VB_MIT_VORL_ÄUFIGER_DECKUNG
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KEINE,
            self::VALUE_VB_OHNE_VORL_ÄUFIGE_DECKUNG,
            self::VALUE_VB_MIT_VORL_ÄUFIGER_DECKUNG,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
