<?php

namespace EnumType;

/**
 * This class stands for tarifvarianteType EnumType
 * @subpackage Enumerations
 */
class TarifvarianteType
{
    /**
     * Constant for value 'ohne Leihwagen'
     * @return string 'ohne Leihwagen'
     */
    const VALUE_OHNE_LEIHWAGEN = 'ohne Leihwagen';
    /**
     * Constant for value 'mit Leihwagen'
     * @return string 'mit Leihwagen'
     */
    const VALUE_MIT_LEIHWAGEN = 'mit Leihwagen';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OHNE_LEIHWAGEN
     * @uses self::VALUE_MIT_LEIHWAGEN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OHNE_LEIHWAGEN,
            self::VALUE_MIT_LEIHWAGEN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
