<?php

namespace EnumType;

/**
 * This class stands for schadenersatzbeitragType EnumType
 * @subpackage Enumerations
 */
class SchadenersatzbeitragType
{
    /**
     * Constant for value 'Nein'
     * @return string 'Nein'
     */
    const VALUE_NEIN = 'Nein';
    /**
     * Constant for value '250,00 EUR/10% Nachlass'
     * @return string '250,00 EUR/10% Nachlass'
     */
    const VALUE_250_00_EUR_10_NACHLASS = '250,00 EUR/10% Nachlass';
    /**
     * Constant for value '350,00 EUR'
     * @return string '350,00 EUR'
     */
    const VALUE_350_00_EUR = '350,00 EUR';
    /**
     * Constant for value '400,00 EUR/20% Nachlass'
     * @return string '400,00 EUR/20% Nachlass'
     */
    const VALUE_400_00_EUR_20_NACHLASS = '400,00 EUR/20% Nachlass';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NEIN
     * @uses self::VALUE_250_00_EUR_10_NACHLASS
     * @uses self::VALUE_350_00_EUR
     * @uses self::VALUE_400_00_EUR_20_NACHLASS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NEIN,
            self::VALUE_250_00_EUR_10_NACHLASS,
            self::VALUE_350_00_EUR,
            self::VALUE_400_00_EUR_20_NACHLASS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
