<?php

namespace EnumType;

/**
 * This class stands for risikoVorschaedenType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Wurden die Gebäude/der Wohnungsinhalt/Keller in den letzten 7 Jahren durch Hochwasser, Überschwemmung, Muren oder Lawinen beschädigt?
 * @subpackage Enumerations
 */
class RisikoVorschaedenType
{
    /**
     * Constant for value 'keine Vorschäden'
     * @return string 'keine Vorschäden'
     */
    const VALUE_KEINE_VORSCH_ÄDEN = 'keine Vorschäden';
    /**
     * Constant for value 'ein Vorschaden'
     * @return string 'ein Vorschaden'
     */
    const VALUE_EIN_VORSCHADEN = 'ein Vorschaden';
    /**
     * Constant for value 'mehr als ein Vorschaden'
     * @return string 'mehr als ein Vorschaden'
     */
    const VALUE_MEHR_ALS_EIN_VORSCHADEN = 'mehr als ein Vorschaden';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KEINE_VORSCH_ÄDEN
     * @uses self::VALUE_EIN_VORSCHADEN
     * @uses self::VALUE_MEHR_ALS_EIN_VORSCHADEN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KEINE_VORSCH_ÄDEN,
            self::VALUE_EIN_VORSCHADEN,
            self::VALUE_MEHR_ALS_EIN_VORSCHADEN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
