<?php

namespace EnumType;

/**
 * This class stands for risikoAusstattungskategorieType EnumType
 * @subpackage Enumerations
 */
class RisikoAusstattungskategorieType
{
    /**
     * Constant for value 'wohnlich'
     * @return string 'wohnlich'
     */
    const VALUE_WOHNLICH = 'wohnlich';
    /**
     * Constant for value 'einfach'
     * @return string 'einfach'
     */
    const VALUE_EINFACH = 'einfach';
    /**
     * Constant for value 'gehoben'
     * @return string 'gehoben'
     */
    const VALUE_GEHOBEN = 'gehoben';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_WOHNLICH
     * @uses self::VALUE_EINFACH
     * @uses self::VALUE_GEHOBEN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_WOHNLICH,
            self::VALUE_EINFACH,
            self::VALUE_GEHOBEN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
