<?php

namespace EnumType;

/**
 * This class stands for polizzenversandType EnumType
 * @subpackage Enumerations
 */
class PolizzenversandType
{
    /**
     * Constant for value 'MAK2'
     * Meta information extracted from the WSDL
     * - documentation: 2fach Makler: Ist nur bei Postversand möglich. Makler erhält Original und Kopie
     * @return string 'MAK2'
     */
    const VALUE_MAK_2 = 'MAK2';
    /**
     * Constant for value 'VN1'
     * Meta information extracted from the WSDL
     * - documentation: 1fach Versicherungsnehmer: Kunde erhält Original
     * @return string 'VN1'
     */
    const VALUE_VN_1 = 'VN1';
    /**
     * Constant for value 'MAKVN'
     * Meta information extracted from the WSDL
     * - documentation: 1fach Makler und 1fach Versicherungsnehmer: Kunde erhält Original und Makler die Kopie
     * @return string 'MAKVN'
     */
    const VALUE_MAKVN = 'MAKVN';
    /**
     * Constant for value 'MAK1'
     * Meta information extracted from the WSDL
     * - documentation: 1fach Makler: Makler erhält Original
     * @return string 'MAK1'
     */
    const VALUE_MAK_1 = 'MAK1';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MAK_2
     * @uses self::VALUE_VN_1
     * @uses self::VALUE_MAKVN
     * @uses self::VALUE_MAK_1
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MAK_2,
            self::VALUE_VN_1,
            self::VALUE_MAKVN,
            self::VALUE_MAK_1,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
