<?php

namespace EnumType;

/**
 * This class stands for PolicyType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Polizzennachspann
 * @subpackage Enumerations
 */
class PolicyType
{
    /**
     * Constant for value 'RS'
     * Meta information extracted from the WSDL
     * - id: Rechtsschutz
     * @return string 'RS'
     */
    const VALUE_RS = 'RS';
    /**
     * Constant for value 'KFZ'
     * Meta information extracted from the WSDL
     * - id: Kfz
     * @return string 'KFZ'
     */
    const VALUE_KFZ = 'KFZ';
    /**
     * Constant for value 'KFR'
     * Meta information extracted from the WSDL
     * - id: KfzUndRechtsschutz
     * @return string 'KFR'
     */
    const VALUE_KFR = 'KFR';
    /**
     * Constant for value 'GEW'
     * Meta information extracted from the WSDL
     * - id: GewerbeGew
     * @return string 'GEW'
     */
    const VALUE_GEW = 'GEW';
    /**
     * Constant for value 'SAC'
     * Meta information extracted from the WSDL
     * - id: Sach
     * @return string 'SAC'
     */
    const VALUE_SAC = 'SAC';
    /**
     * Constant for value 'KU'
     * Meta information extracted from the WSDL
     * - id: Gesundheitsmanagement
     * @return string 'KU'
     */
    const VALUE_KU = 'KU';
    /**
     * Constant for value 'UV'
     * Meta information extracted from the WSDL
     * - id: Unfallvorsorge
     * @return string 'UV'
     */
    const VALUE_UV = 'UV';
    /**
     * Constant for value 'KV'
     * Meta information extracted from the WSDL
     * - id: Gesundheitsvorsorge
     * @return string 'KV'
     */
    const VALUE_KV = 'KV';
    /**
     * Constant for value 'BES'
     * Meta information extracted from the WSDL
     * - id: BesitzBes
     * @return string 'BES'
     */
    const VALUE_BES = 'BES';
    /**
     * Constant for value 'ASS'
     * Meta information extracted from the WSDL
     * - id: Assistance
     * @return string 'ASS'
     */
    const VALUE_ASS = 'ASS';
    /**
     * Constant for value 'WGB'
     * Meta information extracted from the WSDL
     * - id: WohngebaeudeWGB
     * @return string 'WGB'
     */
    const VALUE_WGB = 'WGB';
    /**
     * Constant for value 'FF'
     * Meta information extracted from the WSDL
     * - id: FremdeFuehrung
     * @return string 'FF'
     */
    const VALUE_FF = 'FF';
    /**
     * Constant for value 'TPT'
     * Meta information extracted from the WSDL
     * - id: Transport
     * @return string 'TPT'
     */
    const VALUE_TPT = 'TPT';
    /**
     * Constant for value 'WSK'
     * Meta information extracted from the WSDL
     * - id: Wassersportkasko
     * @return string 'WSK'
     */
    const VALUE_WSK = 'WSK';
    /**
     * Constant for value 'LDW'
     * Meta information extracted from the WSDL
     * - id: LandwirtschaftLDW
     * @return string 'LDW'
     */
    const VALUE_LDW = 'LDW';
    /**
     * Constant for value 'BFT'
     * Meta information extracted from the WSDL
     * - id: Betriebsunterbrechungsversicherung
     * @return string 'BFT'
     */
    const VALUE_BFT = 'BFT';
    /**
     * Constant for value 'BWM'
     * Meta information extracted from the WSDL
     * - id: Bauwesen
     * @return string 'BWM'
     */
    const VALUE_BWM = 'BWM';
    /**
     * Constant for value 'IND'
     * Meta information extracted from the WSDL
     * - id: SachDivers
     * @return string 'IND'
     */
    const VALUE_IND = 'IND';
    /**
     * Constant for value 'HP'
     * Meta information extracted from the WSDL
     * - id: Berufshaftpflicht
     * @return string 'HP'
     */
    const VALUE_HP = 'HP';
    /**
     * Constant for value 'KVG'
     * Meta information extracted from the WSDL
     * - id: GruppenKranken
     * @return string 'KVG'
     */
    const VALUE_KVG = 'KVG';
    /**
     * Constant for value 'UVK'
     * Meta information extracted from the WSDL
     * - id: Kollektivunfall
     * @return string 'UVK'
     */
    const VALUE_UVK = 'UVK';
    /**
     * Constant for value 'KVK'
     * Meta information extracted from the WSDL
     * - id: Kollektivkranken
     * @return string 'KVK'
     */
    const VALUE_KVK = 'KVK';
    /**
     * Constant for value 'LV'
     * Meta information extracted from the WSDL
     * - id: Lebenberatung
     * @return string 'LV'
     */
    const VALUE_LV = 'LV';
    /**
     * Constant for value 'UVG'
     * Meta information extracted from the WSDL
     * - id: UnfallvorsorgeG
     * @return string 'UVG'
     */
    const VALUE_UVG = 'UVG';
    /**
     * Constant for value 'RV'
     * Meta information extracted from the WSDL
     * - id: RahmenVertrag
     * @return string 'RV'
     */
    const VALUE_RV = 'RV';
    /**
     * Constant for value 'REI'
     * Meta information extracted from the WSDL
     * - id: Reiseversicherung
     * @return string 'REI'
     */
    const VALUE_REI = 'REI';
    /**
     * Constant for value 'VIT'
     * Meta information extracted from the WSDL
     * - id: Vitality
     * @return string 'VIT'
     */
    const VALUE_VIT = 'VIT';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_RS
     * @uses self::VALUE_KFZ
     * @uses self::VALUE_KFR
     * @uses self::VALUE_GEW
     * @uses self::VALUE_SAC
     * @uses self::VALUE_KU
     * @uses self::VALUE_UV
     * @uses self::VALUE_KV
     * @uses self::VALUE_BES
     * @uses self::VALUE_ASS
     * @uses self::VALUE_WGB
     * @uses self::VALUE_FF
     * @uses self::VALUE_TPT
     * @uses self::VALUE_WSK
     * @uses self::VALUE_LDW
     * @uses self::VALUE_BFT
     * @uses self::VALUE_BWM
     * @uses self::VALUE_IND
     * @uses self::VALUE_HP
     * @uses self::VALUE_KVG
     * @uses self::VALUE_UVK
     * @uses self::VALUE_KVK
     * @uses self::VALUE_LV
     * @uses self::VALUE_UVG
     * @uses self::VALUE_RV
     * @uses self::VALUE_REI
     * @uses self::VALUE_VIT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_RS,
            self::VALUE_KFZ,
            self::VALUE_KFR,
            self::VALUE_GEW,
            self::VALUE_SAC,
            self::VALUE_KU,
            self::VALUE_UV,
            self::VALUE_KV,
            self::VALUE_BES,
            self::VALUE_ASS,
            self::VALUE_WGB,
            self::VALUE_FF,
            self::VALUE_TPT,
            self::VALUE_WSK,
            self::VALUE_LDW,
            self::VALUE_BFT,
            self::VALUE_BWM,
            self::VALUE_IND,
            self::VALUE_HP,
            self::VALUE_KVG,
            self::VALUE_UVK,
            self::VALUE_KVK,
            self::VALUE_LV,
            self::VALUE_UVG,
            self::VALUE_RV,
            self::VALUE_REI,
            self::VALUE_VIT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
