<?php

namespace EnumType;

/**
 * This class stands for PaymentFrequency EnumType
 * Meta information extracted from the WSDL
 * - documentation: Zahlungsfrequenz der Prämie 1...jährlich 2..halbjährlich 4..vierteljährlich 6..monatlich 99..einmalig 0..unbekannt
 * @subpackage Enumerations
 */
class PaymentFrequency
{
    /**
     * Constant for value '1'
     * Meta information extracted from the WSDL
     * - id: yearly
     * @return string '1'
     */
    const VALUE_1 = '1';
    /**
     * Constant for value '2'
     * Meta information extracted from the WSDL
     * - id: semi-yearly
     * @return string '2'
     */
    const VALUE_2 = '2';
    /**
     * Constant for value '4'
     * Meta information extracted from the WSDL
     * - id: quarterly
     * @return string '4'
     */
    const VALUE_4 = '4';
    /**
     * Constant for value '6'
     * Meta information extracted from the WSDL
     * - id: monthly
     * @return string '6'
     */
    const VALUE_6 = '6';
    /**
     * Constant for value '99'
     * Meta information extracted from the WSDL
     * - id: one-time
     * @return string '99'
     */
    const VALUE_99 = '99';
    /**
     * Constant for value '0'
     * Meta information extracted from the WSDL
     * - id: unkown
     * @return string '0'
     */
    const VALUE_0 = '0';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_1
     * @uses self::VALUE_2
     * @uses self::VALUE_4
     * @uses self::VALUE_6
     * @uses self::VALUE_99
     * @uses self::VALUE_0
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_1,
            self::VALUE_2,
            self::VALUE_4,
            self::VALUE_6,
            self::VALUE_99,
            self::VALUE_0,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
