<?php

namespace EnumType;

/**
 * This class stands for kommunikationsTypType EnumType
 * @subpackage Enumerations
 */
class KommunikationsTypType
{
    /**
     * Constant for value 'Ansprechpartner'
     * @return string 'Ansprechpartner'
     */
    const VALUE_ANSPRECHPARTNER = 'Ansprechpartner';
    /**
     * Constant for value 'E-Mail'
     * @return string 'E-Mail'
     */
    const VALUE_E_MAIL = 'E-Mail';
    /**
     * Constant for value 'Faxanschluss'
     * @return string 'Faxanschluss'
     */
    const VALUE_FAXANSCHLUSS = 'Faxanschluss';
    /**
     * Constant for value 'Mobiltelefon'
     * @return string 'Mobiltelefon'
     */
    const VALUE_MOBILTELEFON = 'Mobiltelefon';
    /**
     * Constant for value 'Telefon (berufl.)'
     * @return string 'Telefon (berufl.)'
     */
    const VALUE_TELEFON_BERUFL = 'Telefon (berufl.)';
    /**
     * Constant for value 'Telefon (privat)'
     * @return string 'Telefon (privat)'
     */
    const VALUE_TELEFON_PRIVAT = 'Telefon (privat)';
    /**
     * Constant for value 'www-Homepage'
     * @return string 'www-Homepage'
     */
    const VALUE_WWW_HOMEPAGE = 'www-Homepage';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ANSPRECHPARTNER
     * @uses self::VALUE_E_MAIL
     * @uses self::VALUE_FAXANSCHLUSS
     * @uses self::VALUE_MOBILTELEFON
     * @uses self::VALUE_TELEFON_BERUFL
     * @uses self::VALUE_TELEFON_PRIVAT
     * @uses self::VALUE_WWW_HOMEPAGE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ANSPRECHPARTNER,
            self::VALUE_E_MAIL,
            self::VALUE_FAXANSCHLUSS,
            self::VALUE_MOBILTELEFON,
            self::VALUE_TELEFON_BERUFL,
            self::VALUE_TELEFON_PRIVAT,
            self::VALUE_WWW_HOMEPAGE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
