<?php

namespace EnumType;

/**
 * This class stands for kmuBranchengruppeType EnumType
 * @subpackage Enumerations
 */
class KmuBranchengruppeType
{
    /**
     * Constant for value 'Architekt'
     * @return string 'Architekt'
     */
    const VALUE_ARCHITEKT = 'Architekt';
    /**
     * Constant for value 'Bäcker'
     * @return string 'Bäcker'
     */
    const VALUE_B_ÄCKER = 'Bäcker';
    /**
     * Constant for value 'Baugewerbe'
     * @return string 'Baugewerbe'
     */
    const VALUE_BAUGEWERBE = 'Baugewerbe';
    /**
     * Constant for value 'Beratung'
     * @return string 'Beratung'
     */
    const VALUE_BERATUNG = 'Beratung';
    /**
     * Constant for value 'Bodenleger'
     * @return string 'Bodenleger'
     */
    const VALUE_BODENLEGER = 'Bodenleger';
    /**
     * Constant for value 'Dachdecker'
     * @return string 'Dachdecker'
     */
    const VALUE_DACHDECKER = 'Dachdecker';
    /**
     * Constant for value 'Einzelhandel'
     * @return string 'Einzelhandel'
     */
    const VALUE_EINZELHANDEL = 'Einzelhandel';
    /**
     * Constant for value 'Elektriker'
     * @return string 'Elektriker'
     */
    const VALUE_ELEKTRIKER = 'Elektriker';
    /**
     * Constant for value 'Gärtner'
     * @return string 'Gärtner'
     */
    const VALUE_G_ÄRTNER = 'Gärtner';
    /**
     * Constant for value 'Gastgewerbe'
     * @return string 'Gastgewerbe'
     */
    const VALUE_GASTGEWERBE = 'Gastgewerbe';
    /**
     * Constant for value 'Gemeinden'
     * @return string 'Gemeinden'
     */
    const VALUE_GEMEINDEN = 'Gemeinden';
    /**
     * Constant for value 'Gesundheits-/Sozialwesen'
     * @return string 'Gesundheits-/Sozialwesen'
     */
    const VALUE_GESUNDHEITS_SOZIALWESEN = 'Gesundheits-/Sozialwesen';
    /**
     * Constant for value 'Glaser'
     * @return string 'Glaser'
     */
    const VALUE_GLASER = 'Glaser';
    /**
     * Constant for value 'Großhandel'
     * @return string 'Großhandel'
     */
    const VALUE_GRO_ßHANDEL = 'Großhandel';
    /**
     * Constant for value 'Herstellung sonst. Nahrungsmittel'
     * @return string 'Herstellung sonst. Nahrungsmittel'
     */
    const VALUE_HERSTELLUNG_SONST_NAHRUNGSMITTEL = 'Herstellung sonst. Nahrungsmittel';
    /**
     * Constant for value 'Herstellung sonst. Waren'
     * @return string 'Herstellung sonst. Waren'
     */
    const VALUE_HERSTELLUNG_SONST_WAREN = 'Herstellung sonst. Waren';
    /**
     * Constant for value 'Ingenieurbüro'
     * @return string 'Ingenieurbüro'
     */
    const VALUE_INGENIEURB_ÜRO = 'Ingenieurbüro';
    /**
     * Constant for value 'Installateur'
     * @return string 'Installateur'
     */
    const VALUE_INSTALLATEUR = 'Installateur';
    /**
     * Constant for value 'IT'
     * @return string 'IT'
     */
    const VALUE_IT = 'IT';
    /**
     * Constant for value 'KFZ-Handel/Reparatur'
     * @return string 'KFZ-Handel/Reparatur'
     */
    const VALUE_KFZ_HANDEL_REPARATUR = 'KFZ-Handel/Reparatur';
    /**
     * Constant for value 'Kultur'
     * @return string 'Kultur'
     */
    const VALUE_KULTUR = 'Kultur';
    /**
     * Constant for value 'Land-/Forstwirtschaft'
     * @return string 'Land-/Forstwirtschaft'
     */
    const VALUE_LAND_FORSTWIRTSCHAFT = 'Land-/Forstwirtschaft';
    /**
     * Constant for value 'Maler'
     * @return string 'Maler'
     */
    const VALUE_MALER = 'Maler';
    /**
     * Constant for value 'Medien'
     * @return string 'Medien'
     */
    const VALUE_MEDIEN = 'Medien';
    /**
     * Constant for value 'Metallbau'
     * @return string 'Metallbau'
     */
    const VALUE_METALLBAU = 'Metallbau';
    /**
     * Constant for value 'Rauchfangkehrer'
     * @return string 'Rauchfangkehrer'
     */
    const VALUE_RAUCHFANGKEHRER = 'Rauchfangkehrer';
    /**
     * Constant for value 'Reisebranche'
     * @return string 'Reisebranche'
     */
    const VALUE_REISEBRANCHE = 'Reisebranche';
    /**
     * Constant for value 'Reparatur/Installation v. Maschinen'
     * @return string 'Reparatur/Installation v. Maschinen'
     */
    const VALUE_REPARATUR_INSTALLATION_V_MASCHINEN = 'Reparatur/Installation v. Maschinen';
    /**
     * Constant for value 'Schlosser'
     * @return string 'Schlosser'
     */
    const VALUE_SCHLOSSER = 'Schlosser';
    /**
     * Constant for value 'Sonst. Dienstleistungen'
     * @return string 'Sonst. Dienstleistungen'
     */
    const VALUE_SONST_DIENSTLEISTUNGEN = 'Sonst. Dienstleistungen';
    /**
     * Constant for value 'Spengler'
     * @return string 'Spengler'
     */
    const VALUE_SPENGLER = 'Spengler';
    /**
     * Constant for value 'Sport'
     * @return string 'Sport'
     */
    const VALUE_SPORT = 'Sport';
    /**
     * Constant for value 'Tischler'
     * @return string 'Tischler'
     */
    const VALUE_TISCHLER = 'Tischler';
    /**
     * Constant for value 'Werbung'
     * @return string 'Werbung'
     */
    const VALUE_WERBUNG = 'Werbung';
    /**
     * Constant for value 'Zimmerer'
     * @return string 'Zimmerer'
     */
    const VALUE_ZIMMERER = 'Zimmerer';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ARCHITEKT
     * @uses self::VALUE_B_ÄCKER
     * @uses self::VALUE_BAUGEWERBE
     * @uses self::VALUE_BERATUNG
     * @uses self::VALUE_BODENLEGER
     * @uses self::VALUE_DACHDECKER
     * @uses self::VALUE_EINZELHANDEL
     * @uses self::VALUE_ELEKTRIKER
     * @uses self::VALUE_G_ÄRTNER
     * @uses self::VALUE_GASTGEWERBE
     * @uses self::VALUE_GEMEINDEN
     * @uses self::VALUE_GESUNDHEITS_SOZIALWESEN
     * @uses self::VALUE_GLASER
     * @uses self::VALUE_GRO_ßHANDEL
     * @uses self::VALUE_HERSTELLUNG_SONST_NAHRUNGSMITTEL
     * @uses self::VALUE_HERSTELLUNG_SONST_WAREN
     * @uses self::VALUE_INGENIEURB_ÜRO
     * @uses self::VALUE_INSTALLATEUR
     * @uses self::VALUE_IT
     * @uses self::VALUE_KFZ_HANDEL_REPARATUR
     * @uses self::VALUE_KULTUR
     * @uses self::VALUE_LAND_FORSTWIRTSCHAFT
     * @uses self::VALUE_MALER
     * @uses self::VALUE_MEDIEN
     * @uses self::VALUE_METALLBAU
     * @uses self::VALUE_RAUCHFANGKEHRER
     * @uses self::VALUE_REISEBRANCHE
     * @uses self::VALUE_REPARATUR_INSTALLATION_V_MASCHINEN
     * @uses self::VALUE_SCHLOSSER
     * @uses self::VALUE_SONST_DIENSTLEISTUNGEN
     * @uses self::VALUE_SPENGLER
     * @uses self::VALUE_SPORT
     * @uses self::VALUE_TISCHLER
     * @uses self::VALUE_WERBUNG
     * @uses self::VALUE_ZIMMERER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ARCHITEKT,
            self::VALUE_B_ÄCKER,
            self::VALUE_BAUGEWERBE,
            self::VALUE_BERATUNG,
            self::VALUE_BODENLEGER,
            self::VALUE_DACHDECKER,
            self::VALUE_EINZELHANDEL,
            self::VALUE_ELEKTRIKER,
            self::VALUE_G_ÄRTNER,
            self::VALUE_GASTGEWERBE,
            self::VALUE_GEMEINDEN,
            self::VALUE_GESUNDHEITS_SOZIALWESEN,
            self::VALUE_GLASER,
            self::VALUE_GRO_ßHANDEL,
            self::VALUE_HERSTELLUNG_SONST_NAHRUNGSMITTEL,
            self::VALUE_HERSTELLUNG_SONST_WAREN,
            self::VALUE_INGENIEURB_ÜRO,
            self::VALUE_INSTALLATEUR,
            self::VALUE_IT,
            self::VALUE_KFZ_HANDEL_REPARATUR,
            self::VALUE_KULTUR,
            self::VALUE_LAND_FORSTWIRTSCHAFT,
            self::VALUE_MALER,
            self::VALUE_MEDIEN,
            self::VALUE_METALLBAU,
            self::VALUE_RAUCHFANGKEHRER,
            self::VALUE_REISEBRANCHE,
            self::VALUE_REPARATUR_INSTALLATION_V_MASCHINEN,
            self::VALUE_SCHLOSSER,
            self::VALUE_SONST_DIENSTLEISTUNGEN,
            self::VALUE_SPENGLER,
            self::VALUE_SPORT,
            self::VALUE_TISCHLER,
            self::VALUE_WERBUNG,
            self::VALUE_ZIMMERER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
