<?php

namespace EnumType;

/**
 * This class stands for kfzVerwendung2Type EnumType
 * @subpackage Enumerations
 */
class KfzVerwendung2Type
{
    /**
     * Constant for value 'Reise'
     * @return string 'Reise'
     */
    const VALUE_REISE = 'Reise';
    /**
     * Constant for value 'Hotel-Gewerbe'
     * @return string 'Hotel-Gewerbe'
     */
    const VALUE_HOTEL_GEWERBE = 'Hotel-Gewerbe';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_REISE
     * @uses self::VALUE_HOTEL_GEWERBE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_REISE,
            self::VALUE_HOTEL_GEWERBE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
