<?php

namespace EnumType;

/**
 * This class stands for juniorSeniorType EnumType
 * @subpackage Enumerations
 */
class JuniorSeniorType
{
    /**
     * Constant for value 'Jun'
     * @return string 'Jun'
     */
    const VALUE_JUN = 'Jun';
    /**
     * Constant for value 'Sen'
     * @return string 'Sen'
     */
    const VALUE_SEN = 'Sen';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_JUN
     * @uses self::VALUE_SEN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_JUN,
            self::VALUE_SEN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
