<?php

namespace EnumType;

/**
 * This class stands for jaNeinType EnumType
 * @subpackage Enumerations
 */
class JaNeinType
{
    /**
     * Constant for value 'ja'
     * @return string 'ja'
     */
    const VALUE_JA = 'ja';
    /**
     * Constant for value 'nein'
     * @return string 'nein'
     */
    const VALUE_NEIN = 'nein';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_JA
     * @uses self::VALUE_NEIN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_JA,
            self::VALUE_NEIN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
