<?php

namespace EnumType;

/**
 * This class stands for FondskategorieType EnumType
 * @subpackage Enumerations
 */
class FondskategorieType
{
    /**
     * Constant for value 'geringesRisiko'
     * @return string 'geringesRisiko'
     */
    const VALUE_GERINGES_RISIKO = 'geringesRisiko';
    /**
     * Constant for value 'mittleresRisiko'
     * @return string 'mittleresRisiko'
     */
    const VALUE_MITTLERES_RISIKO = 'mittleresRisiko';
    /**
     * Constant for value 'hohesRisiko'
     * @return string 'hohesRisiko'
     */
    const VALUE_HOHES_RISIKO = 'hohesRisiko';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GERINGES_RISIKO
     * @uses self::VALUE_MITTLERES_RISIKO
     * @uses self::VALUE_HOHES_RISIKO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GERINGES_RISIKO,
            self::VALUE_MITTLERES_RISIKO,
            self::VALUE_HOHES_RISIKO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
