<?php

namespace EnumType;

/**
 * This class stands for currency EnumType
 * @subpackage Enumerations
 */
class Currency
{
    /**
     * Constant for value 'EUR'
     * @return string 'EUR'
     */
    const VALUE_EUR = 'EUR';
    /**
     * Constant for value 'andere'
     * @return string 'andere'
     */
    const VALUE_ANDERE = 'andere';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EUR
     * @uses self::VALUE_ANDERE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EUR,
            self::VALUE_ANDERE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
