<?php

namespace EnumType;

/**
 * This class stands for bonusMalusVorversicherungType EnumType
 * @subpackage Enumerations
 */
class BonusMalusVorversicherungType
{
    /**
     * Constant for value 'ja'
     * Meta information extracted from the WSDL
     * - documentation: obsolet ab 02/2018
     * @return string 'ja'
     */
    const VALUE_JA = 'ja';
    /**
     * Constant for value 'nein'
     * Meta information extracted from the WSDL
     * - documentation: obsolet ab 02/2018
     * @return string 'nein'
     */
    const VALUE_NEIN = 'nein';
    /**
     * Constant for value 'Ohne Vorversicherung'
     * @return string 'Ohne Vorversicherung'
     */
    const VALUE_OHNE_VORVERSICHERUNG = 'Ohne Vorversicherung';
    /**
     * Constant for value 'Mit Vorversicherung'
     * @return string 'Mit Vorversicherung'
     */
    const VALUE_MIT_VORVERSICHERUNG = 'Mit Vorversicherung';
    /**
     * Constant for value 'BM-Übernahme von Angehörigen'
     * @return string 'BM-Übernahme von Angehörigen'
     */
    const VALUE_BM_ÜBERNAHME_VON_ANGEH_ÖRIGEN = 'BM-Übernahme von Angehörigen';
    /**
     * Constant for value 'BM-Übernahme vom Dienstgeber'
     * @return string 'BM-Übernahme vom Dienstgeber'
     */
    const VALUE_BM_ÜBERNAHME_VOM_DIENSTGEBER = 'BM-Übernahme vom Dienstgeber';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_JA
     * @uses self::VALUE_NEIN
     * @uses self::VALUE_OHNE_VORVERSICHERUNG
     * @uses self::VALUE_MIT_VORVERSICHERUNG
     * @uses self::VALUE_BM_ÜBERNAHME_VON_ANGEH_ÖRIGEN
     * @uses self::VALUE_BM_ÜBERNAHME_VOM_DIENSTGEBER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_JA,
            self::VALUE_NEIN,
            self::VALUE_OHNE_VORVERSICHERUNG,
            self::VALUE_MIT_VORVERSICHERUNG,
            self::VALUE_BM_ÜBERNAHME_VON_ANGEH_ÖRIGEN,
            self::VALUE_BM_ÜBERNAHME_VOM_DIENSTGEBER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
