<?php

namespace EnumType;

/**
 * This class stands for benutzerType EnumType
 * @subpackage Enumerations
 */
class BenutzerType
{
    /**
     * Constant for value 'keine'
     * @return string 'keine'
     */
    const VALUE_KEINE = 'keine';
    /**
     * Constant for value 'Ehepartner/Lebensgefährte'
     * @return string 'Ehepartner/Lebensgefährte'
     */
    const VALUE_EHEPARTNER_LEBENSGEF_ÄHRTE = 'Ehepartner/Lebensgefährte';
    /**
     * Constant for value 'Ehepartner/Lebensgefährte/Kinder'
     * @return string 'Ehepartner/Lebensgefährte/Kinder'
     */
    const VALUE_EHEPARTNER_LEBENSGEF_ÄHRTE_KINDER = 'Ehepartner/Lebensgefährte/Kinder';
    /**
     * Constant for value 'andere Personen'
     * @return string 'andere Personen'
     */
    const VALUE_ANDERE_PERSONEN = 'andere Personen';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KEINE
     * @uses self::VALUE_EHEPARTNER_LEBENSGEF_ÄHRTE
     * @uses self::VALUE_EHEPARTNER_LEBENSGEF_ÄHRTE_KINDER
     * @uses self::VALUE_ANDERE_PERSONEN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KEINE,
            self::VALUE_EHEPARTNER_LEBENSGEF_ÄHRTE,
            self::VALUE_EHEPARTNER_LEBENSGEF_ÄHRTE_KINDER,
            self::VALUE_ANDERE_PERSONEN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
