<?php

namespace EnumType;

/**
 * This class stands for befreiungsgrundType EnumType
 * @subpackage Enumerations
 */
class BefreiungsgrundType
{
    /**
     * Constant for value 'kein Befreiungsgrund'
     * @return string 'kein Befreiungsgrund'
     */
    const VALUE_KEIN_BEFREIUNGSGRUND = 'kein Befreiungsgrund';
    /**
     * Constant for value 'KFZ des Bundes od. Gebietskörperschaften zur Verwendung im
     * öffentl. Sicherheitsdienst'
     * @return string 'KFZ des Bundes od. Gebietskörperschaften zur Verwendung im öffentl. Sicherheitsdienst'
     */
    const VALUE_KFZ_DES_BUNDES_OD_GEBIETSK_ÖRPERSCHAFTEN_ZUR_VERWENDUNG_IM_ÖFFENTL_SICHERHEITSDIENST = 'KFZ des Bundes od. Gebietskörperschaften zur Verwendung im öffentl. Sicherheitsdienst';
    /**
     * Constant for value 'KFZ unterliegt nicht der Steuerpflicht'
     * @return string 'KFZ unterliegt nicht der Steuerpflicht'
     */
    const VALUE_KFZ_UNTERLIEGT_NICHT_DER_STEUERPFLICHT = 'KFZ unterliegt nicht der Steuerpflicht';
    /**
     * Constant for value 'KFZ zur Verw. für Körperbehinderte'
     * @return string 'KFZ zur Verw. für Körperbehinderte'
     */
    const VALUE_KFZ_ZUR_VERW_F_ÜR_K_ÖRPERBEHINDERTE = 'KFZ zur Verw. für Körperbehinderte';
    /**
     * Constant for value 'Hoteltaxi'
     * @return string 'Hoteltaxi'
     */
    const VALUE_HOTELTAXI = 'Hoteltaxi';
    /**
     * Constant for value 'Diplomat (ohne VSSt Befreiung)'
     * @return string 'Diplomat (ohne VSSt Befreiung)'
     */
    const VALUE_DIPLOMAT_OHNE_VSST_BEFREIUNG = 'Diplomat (ohne VSSt Befreiung)';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KEIN_BEFREIUNGSGRUND
     * @uses self::VALUE_KFZ_DES_BUNDES_OD_GEBIETSK_ÖRPERSCHAFTEN_ZUR_VERWENDUNG_IM_ÖFFENTL_SICHERHEITSDIENST
     * @uses self::VALUE_KFZ_UNTERLIEGT_NICHT_DER_STEUERPFLICHT
     * @uses self::VALUE_KFZ_ZUR_VERW_F_ÜR_K_ÖRPERBEHINDERTE
     * @uses self::VALUE_HOTELTAXI
     * @uses self::VALUE_DIPLOMAT_OHNE_VSST_BEFREIUNG
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KEIN_BEFREIUNGSGRUND,
            self::VALUE_KFZ_DES_BUNDES_OD_GEBIETSK_ÖRPERSCHAFTEN_ZUR_VERWENDUNG_IM_ÖFFENTL_SICHERHEITSDIENST,
            self::VALUE_KFZ_UNTERLIEGT_NICHT_DER_STEUERPFLICHT,
            self::VALUE_KFZ_ZUR_VERW_F_ÜR_K_ÖRPERBEHINDERTE,
            self::VALUE_HOTELTAXI,
            self::VALUE_DIPLOMAT_OHNE_VSST_BEFREIUNG,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
