<?php

namespace EnumType;

/**
 * This class stands for banklandType EnumType
 * @subpackage Enumerations
 */
class BanklandType
{
    /**
     * Constant for value 'Österreich'
     * @return string 'Österreich'
     */
    const VALUE_ÖSTERREICH = 'Österreich';
    /**
     * Constant for value 'Deutschland'
     * @return string 'Deutschland'
     */
    const VALUE_DEUTSCHLAND = 'Deutschland';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ÖSTERREICH
     * @uses self::VALUE_DEUTSCHLAND
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ÖSTERREICH,
            self::VALUE_DEUTSCHLAND,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
