<?php

namespace EnumType;

/**
 * This class stands for aufbauLkwType EnumType
 * @subpackage Enumerations
 */
class AufbauLkwType
{
    /**
     * Constant for value 'Keine'
     * @return string 'Keine'
     */
    const VALUE_KEINE = 'Keine';
    /**
     * Constant for value 'Pritsche'
     * @return string 'Pritsche'
     */
    const VALUE_PRITSCHE = 'Pritsche';
    /**
     * Constant for value 'Rungen'
     * @return string 'Rungen'
     */
    const VALUE_RUNGEN = 'Rungen';
    /**
     * Constant for value 'Kasten/Koffer (ausgen. Kühlaufbauten)'
     * @return string 'Kasten/Koffer (ausgen. Kühlaufbauten)'
     */
    const VALUE_KASTEN_KOFFER_AUSGEN_K_ÜHLAUFBAUTEN = 'Kasten/Koffer (ausgen. Kühlaufbauten)';
    /**
     * Constant for value 'Kipper'
     * @return string 'Kipper'
     */
    const VALUE_KIPPER = 'Kipper';
    /**
     * Constant for value 'Ladebordwand'
     * @return string 'Ladebordwand'
     */
    const VALUE_LADEBORDWAND = 'Ladebordwand';
    /**
     * Constant for value 'Ladekran'
     * @return string 'Ladekran'
     */
    const VALUE_LADEKRAN = 'Ladekran';
    /**
     * Constant for value 'offen'
     * @return string 'offen'
     */
    const VALUE_OFFEN = 'offen';
    /**
     * Constant for value 'Tieflader'
     * @return string 'Tieflader'
     */
    const VALUE_TIEFLADER = 'Tieflader';
    /**
     * Constant for value 'Tanker'
     * @return string 'Tanker'
     */
    const VALUE_TANKER = 'Tanker';
    /**
     * Constant for value 'Silo'
     * @return string 'Silo'
     */
    const VALUE_SILO = 'Silo';
    /**
     * Constant for value 'Müllwagen'
     * @return string 'Müllwagen'
     */
    const VALUE_M_ÜLLWAGEN = 'Müllwagen';
    /**
     * Constant for value 'Kühlwagen'
     * @return string 'Kühlwagen'
     */
    const VALUE_K_ÜHLWAGEN = 'Kühlwagen';
    /**
     * Constant for value 'ohne Aufbau'
     * @return string 'ohne Aufbau'
     */
    const VALUE_OHNE_AUFBAU = 'ohne Aufbau';
    /**
     * Constant for value 'Spriegel mit Plane'
     * @return string 'Spriegel mit Plane'
     */
    const VALUE_SPRIEGEL_MIT_PLANE = 'Spriegel mit Plane';
    /**
     * Constant for value 'Hebebühne'
     * @return string 'Hebebühne'
     */
    const VALUE_HEBEB_ÜHNE = 'Hebebühne';
    /**
     * Constant for value 'Getränkeaufbau'
     * @return string 'Getränkeaufbau'
     */
    const VALUE_GETR_ÄNKEAUFBAU = 'Getränkeaufbau';
    /**
     * Constant for value 'Rampen'
     * @return string 'Rampen'
     */
    const VALUE_RAMPEN = 'Rampen';
    /**
     * Constant for value 'Fäkalienfahrzeug'
     * @return string 'Fäkalienfahrzeug'
     */
    const VALUE_F_ÄKALIENFAHRZEUG = 'Fäkalienfahrzeug';
    /**
     * Constant for value 'Betonmischer'
     * @return string 'Betonmischer'
     */
    const VALUE_BETONMISCHER = 'Betonmischer';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KEINE
     * @uses self::VALUE_PRITSCHE
     * @uses self::VALUE_RUNGEN
     * @uses self::VALUE_KASTEN_KOFFER_AUSGEN_K_ÜHLAUFBAUTEN
     * @uses self::VALUE_KIPPER
     * @uses self::VALUE_LADEBORDWAND
     * @uses self::VALUE_LADEKRAN
     * @uses self::VALUE_OFFEN
     * @uses self::VALUE_TIEFLADER
     * @uses self::VALUE_TANKER
     * @uses self::VALUE_SILO
     * @uses self::VALUE_M_ÜLLWAGEN
     * @uses self::VALUE_K_ÜHLWAGEN
     * @uses self::VALUE_OHNE_AUFBAU
     * @uses self::VALUE_SPRIEGEL_MIT_PLANE
     * @uses self::VALUE_HEBEB_ÜHNE
     * @uses self::VALUE_GETR_ÄNKEAUFBAU
     * @uses self::VALUE_RAMPEN
     * @uses self::VALUE_F_ÄKALIENFAHRZEUG
     * @uses self::VALUE_BETONMISCHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KEINE,
            self::VALUE_PRITSCHE,
            self::VALUE_RUNGEN,
            self::VALUE_KASTEN_KOFFER_AUSGEN_K_ÜHLAUFBAUTEN,
            self::VALUE_KIPPER,
            self::VALUE_LADEBORDWAND,
            self::VALUE_LADEKRAN,
            self::VALUE_OFFEN,
            self::VALUE_TIEFLADER,
            self::VALUE_TANKER,
            self::VALUE_SILO,
            self::VALUE_M_ÜLLWAGEN,
            self::VALUE_K_ÜHLWAGEN,
            self::VALUE_OHNE_AUFBAU,
            self::VALUE_SPRIEGEL_MIT_PLANE,
            self::VALUE_HEBEB_ÜHNE,
            self::VALUE_GETR_ÄNKEAUFBAU,
            self::VALUE_RAMPEN,
            self::VALUE_F_ÄKALIENFAHRZEUG,
            self::VALUE_BETONMISCHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
