<?php

namespace EnumType;

/**
 * This class stands for anredeType EnumType
 * @subpackage Enumerations
 */
class AnredeType
{
    /**
     * Constant for value 'Herr'
     * @return string 'Herr'
     */
    const VALUE_HERR = 'Herr';
    /**
     * Constant for value 'Frau'
     * @return string 'Frau'
     */
    const VALUE_FRAU = 'Frau';
    /**
     * Constant for value 'Firma'
     * @return string 'Firma'
     */
    const VALUE_FIRMA = 'Firma';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_HERR
     * @uses self::VALUE_FRAU
     * @uses self::VALUE_FIRMA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_HERR,
            self::VALUE_FRAU,
            self::VALUE_FIRMA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
