<?php

namespace EnumType;

/**
 * This class stands for NetsisFaturaAktarimindaKullanilacakSube EnumType
 * @subpackage Enumerations
 */
class NetsisFaturaAktarimindaKullanilacakSube
{
    /**
     * Constant for value 'SistemYoneticisindeTanimlanmisSube'
     * @return string 'SistemYoneticisindeTanimlanmisSube'
     */
    const VALUE_SISTEM_YONETICISINDE_TANIMLANMIS_SUBE = 'SistemYoneticisindeTanimlanmisSube';
    /**
     * Constant for value 'STNo'
     * @return string 'STNo'
     */
    const VALUE_STNO = 'STNo';
    /**
     * Constant for value 'DepoNo'
     * @return string 'DepoNo'
     */
    const VALUE_DEPO_NO = 'DepoNo';
    /**
     * Constant for value 'OzelKod'
     * @return string 'OzelKod'
     */
    const VALUE_OZEL_KOD = 'OzelKod';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SISTEM_YONETICISINDE_TANIMLANMIS_SUBE
     * @uses self::VALUE_STNO
     * @uses self::VALUE_DEPO_NO
     * @uses self::VALUE_OZEL_KOD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SISTEM_YONETICISINDE_TANIMLANMIS_SUBE,
            self::VALUE_STNO,
            self::VALUE_DEPO_NO,
            self::VALUE_OZEL_KOD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
