<?php

namespace EnumType;

/**
 * This class stands for FaturaOzelKodAktarimTip EnumType
 * @subpackage Enumerations
 */
class FaturaOzelKodAktarimTip
{
    /**
     * Constant for value 'Aktarma'
     * @return string 'Aktarma'
     */
    const VALUE_AKTARMA = 'Aktarma';
    /**
     * Constant for value 'SatisTemsilcisi'
     * @return string 'SatisTemsilcisi'
     */
    const VALUE_SATIS_TEMSILCISI = 'SatisTemsilcisi';
    /**
     * Constant for value 'OdemeTipi'
     * @return string 'OdemeTipi'
     */
    const VALUE_ODEME_TIPI = 'OdemeTipi';
    /**
     * Constant for value 'OdemeTipiveST'
     * @return string 'OdemeTipiveST'
     */
    const VALUE_ODEME_TIPIVE_ST = 'OdemeTipiveST';
    /**
     * Constant for value 'OdemeTipiveOzelKod'
     * @return string 'OdemeTipiveOzelKod'
     */
    const VALUE_ODEME_TIPIVE_OZEL_KOD = 'OdemeTipiveOzelKod';
    /**
     * Constant for value 'OzelKod'
     * @return string 'OzelKod'
     */
    const VALUE_OZEL_KOD = 'OzelKod';
    /**
     * Constant for value 'AracKodu'
     * @return string 'AracKodu'
     */
    const VALUE_ARAC_KODU = 'AracKodu';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AKTARMA
     * @uses self::VALUE_SATIS_TEMSILCISI
     * @uses self::VALUE_ODEME_TIPI
     * @uses self::VALUE_ODEME_TIPIVE_ST
     * @uses self::VALUE_ODEME_TIPIVE_OZEL_KOD
     * @uses self::VALUE_OZEL_KOD
     * @uses self::VALUE_ARAC_KODU
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AKTARMA,
            self::VALUE_SATIS_TEMSILCISI,
            self::VALUE_ODEME_TIPI,
            self::VALUE_ODEME_TIPIVE_ST,
            self::VALUE_ODEME_TIPIVE_OZEL_KOD,
            self::VALUE_OZEL_KOD,
            self::VALUE_ARAC_KODU,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
