<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsVergiDairesi StructType
 * @subpackage Structs
 */
class ClsVergiDairesi extends ClsSharedVergiDairesi
{
    /**
     * The Sonislemtarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Sonislemtarihi;
    /**
     * The Sonkullanicikod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Sonkullanicikod;
    /**
     * The Ilkislemtarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Ilkislemtarihi;
    /**
     * The Ilkkullanicikod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Ilkkullanicikod;
    /**
     * The Sonislemhost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Sonislemhost;
    /**
     * The Referans
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Referans;
    /**
     * Constructor method for clsVergiDairesi
     * @uses ClsVergiDairesi::setSonislemtarihi()
     * @uses ClsVergiDairesi::setSonkullanicikod()
     * @uses ClsVergiDairesi::setIlkislemtarihi()
     * @uses ClsVergiDairesi::setIlkkullanicikod()
     * @uses ClsVergiDairesi::setSonislemhost()
     * @uses ClsVergiDairesi::setReferans()
     * @param string $sonislemtarihi
     * @param int $sonkullanicikod
     * @param string $ilkislemtarihi
     * @param int $ilkkullanicikod
     * @param string $sonislemhost
     * @param string $referans
     */
    public function __construct($sonislemtarihi = null, $sonkullanicikod = null, $ilkislemtarihi = null, $ilkkullanicikod = null, $sonislemhost = null, $referans = null)
    {
        $this
            ->setSonislemtarihi($sonislemtarihi)
            ->setSonkullanicikod($sonkullanicikod)
            ->setIlkislemtarihi($ilkislemtarihi)
            ->setIlkkullanicikod($ilkkullanicikod)
            ->setSonislemhost($sonislemhost)
            ->setReferans($referans);
    }
    /**
     * Get Sonislemtarihi value
     * @return string
     */
    public function getSonislemtarihi()
    {
        return $this->Sonislemtarihi;
    }
    /**
     * Set Sonislemtarihi value
     * @param string $sonislemtarihi
     * @return \StructType\ClsVergiDairesi
     */
    public function setSonislemtarihi($sonislemtarihi = null)
    {
        // validation for constraint: string
        if (!is_null($sonislemtarihi) && !is_string($sonislemtarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sonislemtarihi, true), gettype($sonislemtarihi)), __LINE__);
        }
        $this->Sonislemtarihi = $sonislemtarihi;
        return $this;
    }
    /**
     * Get Sonkullanicikod value
     * @return int
     */
    public function getSonkullanicikod()
    {
        return $this->Sonkullanicikod;
    }
    /**
     * Set Sonkullanicikod value
     * @param int $sonkullanicikod
     * @return \StructType\ClsVergiDairesi
     */
    public function setSonkullanicikod($sonkullanicikod = null)
    {
        // validation for constraint: int
        if (!is_null($sonkullanicikod) && !(is_int($sonkullanicikod) || ctype_digit($sonkullanicikod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sonkullanicikod, true), gettype($sonkullanicikod)), __LINE__);
        }
        $this->Sonkullanicikod = $sonkullanicikod;
        return $this;
    }
    /**
     * Get Ilkislemtarihi value
     * @return string
     */
    public function getIlkislemtarihi()
    {
        return $this->Ilkislemtarihi;
    }
    /**
     * Set Ilkislemtarihi value
     * @param string $ilkislemtarihi
     * @return \StructType\ClsVergiDairesi
     */
    public function setIlkislemtarihi($ilkislemtarihi = null)
    {
        // validation for constraint: string
        if (!is_null($ilkislemtarihi) && !is_string($ilkislemtarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ilkislemtarihi, true), gettype($ilkislemtarihi)), __LINE__);
        }
        $this->Ilkislemtarihi = $ilkislemtarihi;
        return $this;
    }
    /**
     * Get Ilkkullanicikod value
     * @return int
     */
    public function getIlkkullanicikod()
    {
        return $this->Ilkkullanicikod;
    }
    /**
     * Set Ilkkullanicikod value
     * @param int $ilkkullanicikod
     * @return \StructType\ClsVergiDairesi
     */
    public function setIlkkullanicikod($ilkkullanicikod = null)
    {
        // validation for constraint: int
        if (!is_null($ilkkullanicikod) && !(is_int($ilkkullanicikod) || ctype_digit($ilkkullanicikod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ilkkullanicikod, true), gettype($ilkkullanicikod)), __LINE__);
        }
        $this->Ilkkullanicikod = $ilkkullanicikod;
        return $this;
    }
    /**
     * Get Sonislemhost value
     * @return string|null
     */
    public function getSonislemhost()
    {
        return $this->Sonislemhost;
    }
    /**
     * Set Sonislemhost value
     * @param string $sonislemhost
     * @return \StructType\ClsVergiDairesi
     */
    public function setSonislemhost($sonislemhost = null)
    {
        // validation for constraint: string
        if (!is_null($sonislemhost) && !is_string($sonislemhost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sonislemhost, true), gettype($sonislemhost)), __LINE__);
        }
        $this->Sonislemhost = $sonislemhost;
        return $this;
    }
    /**
     * Get Referans value
     * @return string|null
     */
    public function getReferans()
    {
        return $this->Referans;
    }
    /**
     * Set Referans value
     * @param string $referans
     * @return \StructType\ClsVergiDairesi
     */
    public function setReferans($referans = null)
    {
        // validation for constraint: string
        if (!is_null($referans) && !is_string($referans)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referans, true), gettype($referans)), __LINE__);
        }
        $this->Referans = $referans;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsVergiDairesi
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
