<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsRutPlan StructType
 * @subpackage Structs
 */
class ClsRutPlan extends ClsEntity
{
    /**
     * The SEKod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SEKod;
    /**
     * The HaftaKod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $HaftaKod;
    /**
     * The GunKod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $GunKod;
    /**
     * The RutKod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $RutKod;
    /**
     * The SonIslemTarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SonIslemTarihi;
    /**
     * The SonIslemHost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SonIslemHost;
    /**
     * The Referans
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Referans;
    /**
     * Constructor method for clsRutPlan
     * @uses ClsRutPlan::setSEKod()
     * @uses ClsRutPlan::setHaftaKod()
     * @uses ClsRutPlan::setGunKod()
     * @uses ClsRutPlan::setRutKod()
     * @uses ClsRutPlan::setSonIslemTarihi()
     * @uses ClsRutPlan::setSonIslemHost()
     * @uses ClsRutPlan::setReferans()
     * @param int $sEKod
     * @param string $haftaKod
     * @param string $gunKod
     * @param int $rutKod
     * @param string $sonIslemTarihi
     * @param string $sonIslemHost
     * @param string $referans
     */
    public function __construct($sEKod = null, $haftaKod = null, $gunKod = null, $rutKod = null, $sonIslemTarihi = null, $sonIslemHost = null, $referans = null)
    {
        $this
            ->setSEKod($sEKod)
            ->setHaftaKod($haftaKod)
            ->setGunKod($gunKod)
            ->setRutKod($rutKod)
            ->setSonIslemTarihi($sonIslemTarihi)
            ->setSonIslemHost($sonIslemHost)
            ->setReferans($referans);
    }
    /**
     * Get SEKod value
     * @return int
     */
    public function getSEKod()
    {
        return $this->SEKod;
    }
    /**
     * Set SEKod value
     * @param int $sEKod
     * @return \StructType\ClsRutPlan
     */
    public function setSEKod($sEKod = null)
    {
        // validation for constraint: int
        if (!is_null($sEKod) && !(is_int($sEKod) || ctype_digit($sEKod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sEKod, true), gettype($sEKod)), __LINE__);
        }
        $this->SEKod = $sEKod;
        return $this;
    }
    /**
     * Get HaftaKod value
     * @return string
     */
    public function getHaftaKod()
    {
        return $this->HaftaKod;
    }
    /**
     * Set HaftaKod value
     * @param string $haftaKod
     * @return \StructType\ClsRutPlan
     */
    public function setHaftaKod($haftaKod = null)
    {
        // validation for constraint: string
        if (!is_null($haftaKod) && !is_string($haftaKod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($haftaKod, true), gettype($haftaKod)), __LINE__);
        }
        $this->HaftaKod = $haftaKod;
        return $this;
    }
    /**
     * Get GunKod value
     * @return string
     */
    public function getGunKod()
    {
        return $this->GunKod;
    }
    /**
     * Set GunKod value
     * @param string $gunKod
     * @return \StructType\ClsRutPlan
     */
    public function setGunKod($gunKod = null)
    {
        // validation for constraint: string
        if (!is_null($gunKod) && !is_string($gunKod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gunKod, true), gettype($gunKod)), __LINE__);
        }
        $this->GunKod = $gunKod;
        return $this;
    }
    /**
     * Get RutKod value
     * @return int
     */
    public function getRutKod()
    {
        return $this->RutKod;
    }
    /**
     * Set RutKod value
     * @param int $rutKod
     * @return \StructType\ClsRutPlan
     */
    public function setRutKod($rutKod = null)
    {
        // validation for constraint: int
        if (!is_null($rutKod) && !(is_int($rutKod) || ctype_digit($rutKod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rutKod, true), gettype($rutKod)), __LINE__);
        }
        $this->RutKod = $rutKod;
        return $this;
    }
    /**
     * Get SonIslemTarihi value
     * @return string
     */
    public function getSonIslemTarihi()
    {
        return $this->SonIslemTarihi;
    }
    /**
     * Set SonIslemTarihi value
     * @param string $sonIslemTarihi
     * @return \StructType\ClsRutPlan
     */
    public function setSonIslemTarihi($sonIslemTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($sonIslemTarihi) && !is_string($sonIslemTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sonIslemTarihi, true), gettype($sonIslemTarihi)), __LINE__);
        }
        $this->SonIslemTarihi = $sonIslemTarihi;
        return $this;
    }
    /**
     * Get SonIslemHost value
     * @return string|null
     */
    public function getSonIslemHost()
    {
        return $this->SonIslemHost;
    }
    /**
     * Set SonIslemHost value
     * @param string $sonIslemHost
     * @return \StructType\ClsRutPlan
     */
    public function setSonIslemHost($sonIslemHost = null)
    {
        // validation for constraint: string
        if (!is_null($sonIslemHost) && !is_string($sonIslemHost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sonIslemHost, true), gettype($sonIslemHost)), __LINE__);
        }
        $this->SonIslemHost = $sonIslemHost;
        return $this;
    }
    /**
     * Get Referans value
     * @return string|null
     */
    public function getReferans()
    {
        return $this->Referans;
    }
    /**
     * Set Referans value
     * @param string $referans
     * @return \StructType\ClsRutPlan
     */
    public function setReferans($referans = null)
    {
        // validation for constraint: string
        if (!is_null($referans) && !is_string($referans)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referans, true), gettype($referans)), __LINE__);
        }
        $this->Referans = $referans;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsRutPlan
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
