<?php

namespace EnumType;

/**
 * This class stands for PaketTipi EnumType
 * @subpackage Enumerations
 */
class PaketTipi
{
    /**
     * Constant for value 'Merkeze'
     * @return string 'Merkeze'
     */
    const VALUE_MERKEZE = 'Merkeze';
    /**
     * Constant for value 'Merkezden'
     * @return string 'Merkezden'
     */
    const VALUE_MERKEZDEN = 'Merkezden';
    /**
     * Constant for value 'MerkezdenWebServisiMusteri'
     * @return string 'MerkezdenWebServisiMusteri'
     */
    const VALUE_MERKEZDEN_WEB_SERVISI_MUSTERI = 'MerkezdenWebServisiMusteri';
    /**
     * Constant for value 'MerkezdenWebServisiFiyatVade'
     * @return string 'MerkezdenWebServisiFiyatVade'
     */
    const VALUE_MERKEZDEN_WEB_SERVISI_FIYAT_VADE = 'MerkezdenWebServisiFiyatVade';
    /**
     * Constant for value 'MerkezdenWebServisiKarsiliklar'
     * @return string 'MerkezdenWebServisiKarsiliklar'
     */
    const VALUE_MERKEZDEN_WEB_SERVISI_KARSILIKLAR = 'MerkezdenWebServisiKarsiliklar';
    /**
     * Constant for value 'MerkezdenESY'
     * @return string 'MerkezdenESY'
     */
    const VALUE_MERKEZDEN_ESY = 'MerkezdenESY';
    /**
     * Constant for value 'ESYdenMerkeze'
     * @return string 'ESYdenMerkeze'
     */
    const VALUE_ESYDEN_MERKEZE = 'ESYdenMerkeze';
    /**
     * Constant for value 'MerkezdenQueste'
     * @return string 'MerkezdenQueste'
     */
    const VALUE_MERKEZDEN_QUESTE = 'MerkezdenQueste';
    /**
     * Constant for value 'QuesttenMerkeze'
     * @return string 'QuesttenMerkeze'
     */
    const VALUE_QUESTTEN_MERKEZE = 'QuesttenMerkeze';
    /**
     * Constant for value 'OleDbTexttenMerkeze'
     * @return string 'OleDbTexttenMerkeze'
     */
    const VALUE_OLE_DB_TEXTTEN_MERKEZE = 'OleDbTexttenMerkeze';
    /**
     * Constant for value 'OleDbMerkezdenTexte'
     * @return string 'OleDbMerkezdenTexte'
     */
    const VALUE_OLE_DB_MERKEZDEN_TEXTE = 'OleDbMerkezdenTexte';
    /**
     * Constant for value 'HedefBilgilerinSAPdenAlinmasi'
     * @return string 'HedefBilgilerinSAPdenAlinmasi'
     */
    const VALUE_HEDEF_BILGILERIN_SAPDEN_ALINMASI = 'HedefBilgilerinSAPdenAlinmasi';
    /**
     * Constant for value 'WebService1'
     * @return string 'WebService1'
     */
    const VALUE_WEB_SERVICE_1 = 'WebService1';
    /**
     * Constant for value 'WebService2'
     * @return string 'WebService2'
     */
    const VALUE_WEB_SERVICE_2 = 'WebService2';
    /**
     * Constant for value 'WebService3'
     * @return string 'WebService3'
     */
    const VALUE_WEB_SERVICE_3 = 'WebService3';
    /**
     * Constant for value 'WebService4'
     * @return string 'WebService4'
     */
    const VALUE_WEB_SERVICE_4 = 'WebService4';
    /**
     * Constant for value 'WebService5'
     * @return string 'WebService5'
     */
    const VALUE_WEB_SERVICE_5 = 'WebService5';
    /**
     * Constant for value 'WebService6'
     * @return string 'WebService6'
     */
    const VALUE_WEB_SERVICE_6 = 'WebService6';
    /**
     * Constant for value 'OleDbExceldenMerkeze'
     * @return string 'OleDbExceldenMerkeze'
     */
    const VALUE_OLE_DB_EXCELDEN_MERKEZE = 'OleDbExceldenMerkeze';
    /**
     * Constant for value 'OleDbMerkezdenExcele'
     * @return string 'OleDbMerkezdenExcele'
     */
    const VALUE_OLE_DB_MERKEZDEN_EXCELE = 'OleDbMerkezdenExcele';
    /**
     * Constant for value 'PanoramaRecovery'
     * @return string 'PanoramaRecovery'
     */
    const VALUE_PANORAMA_RECOVERY = 'PanoramaRecovery';
    /**
     * Constant for value 'PanoramadanERPyeOnayli'
     * @return string 'PanoramadanERPyeOnayli'
     */
    const VALUE_PANORAMADAN_ERPYE_ONAYLI = 'PanoramadanERPyeOnayli';
    /**
     * Constant for value 'WMSEntegrasyonSabit'
     * @return string 'WMSEntegrasyonSabit'
     */
    const VALUE_WMSENTEGRASYON_SABIT = 'WMSEntegrasyonSabit';
    /**
     * Constant for value 'WMSEntegrasyonHareket'
     * @return string 'WMSEntegrasyonHareket'
     */
    const VALUE_WMSENTEGRASYON_HAREKET = 'WMSEntegrasyonHareket';
    /**
     * Constant for value 'RaporMailGonder'
     * @return string 'RaporMailGonder'
     */
    const VALUE_RAPOR_MAIL_GONDER = 'RaporMailGonder';
    /**
     * Constant for value 'EkipmanSayim'
     * @return string 'EkipmanSayim'
     */
    const VALUE_EKIPMAN_SAYIM = 'EkipmanSayim';
    /**
     * Constant for value 'PanoramadanVerSiparisinePeriyodik'
     * @return string 'PanoramadanVerSiparisinePeriyodik'
     */
    const VALUE_PANORAMADAN_VER_SIPARISINE_PERIYODIK = 'PanoramadanVerSiparisinePeriyodik';
    /**
     * Constant for value 'PanoramadanVerSiparisineAnlik'
     * @return string 'PanoramadanVerSiparisineAnlik'
     */
    const VALUE_PANORAMADAN_VER_SIPARISINE_ANLIK = 'PanoramadanVerSiparisineAnlik';
    /**
     * Constant for value 'PanoramalarArasiEntegrasyonMerkez'
     * @return string 'PanoramalarArasiEntegrasyonMerkez'
     */
    const VALUE_PANORAMALAR_ARASI_ENTEGRASYON_MERKEZ = 'PanoramalarArasiEntegrasyonMerkez';
    /**
     * Constant for value 'PanoramalarArasiEntegrasyonVeriAlma'
     * @return string 'PanoramalarArasiEntegrasyonVeriAlma'
     */
    const VALUE_PANORAMALAR_ARASI_ENTEGRASYON_VERI_ALMA = 'PanoramalarArasiEntegrasyonVeriAlma';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MERKEZE
     * @uses self::VALUE_MERKEZDEN
     * @uses self::VALUE_MERKEZDEN_WEB_SERVISI_MUSTERI
     * @uses self::VALUE_MERKEZDEN_WEB_SERVISI_FIYAT_VADE
     * @uses self::VALUE_MERKEZDEN_WEB_SERVISI_KARSILIKLAR
     * @uses self::VALUE_MERKEZDEN_ESY
     * @uses self::VALUE_ESYDEN_MERKEZE
     * @uses self::VALUE_MERKEZDEN_QUESTE
     * @uses self::VALUE_QUESTTEN_MERKEZE
     * @uses self::VALUE_OLE_DB_TEXTTEN_MERKEZE
     * @uses self::VALUE_OLE_DB_MERKEZDEN_TEXTE
     * @uses self::VALUE_HEDEF_BILGILERIN_SAPDEN_ALINMASI
     * @uses self::VALUE_WEB_SERVICE_1
     * @uses self::VALUE_WEB_SERVICE_2
     * @uses self::VALUE_WEB_SERVICE_3
     * @uses self::VALUE_WEB_SERVICE_4
     * @uses self::VALUE_WEB_SERVICE_5
     * @uses self::VALUE_WEB_SERVICE_6
     * @uses self::VALUE_OLE_DB_EXCELDEN_MERKEZE
     * @uses self::VALUE_OLE_DB_MERKEZDEN_EXCELE
     * @uses self::VALUE_PANORAMA_RECOVERY
     * @uses self::VALUE_PANORAMADAN_ERPYE_ONAYLI
     * @uses self::VALUE_WMSENTEGRASYON_SABIT
     * @uses self::VALUE_WMSENTEGRASYON_HAREKET
     * @uses self::VALUE_RAPOR_MAIL_GONDER
     * @uses self::VALUE_EKIPMAN_SAYIM
     * @uses self::VALUE_PANORAMADAN_VER_SIPARISINE_PERIYODIK
     * @uses self::VALUE_PANORAMADAN_VER_SIPARISINE_ANLIK
     * @uses self::VALUE_PANORAMALAR_ARASI_ENTEGRASYON_MERKEZ
     * @uses self::VALUE_PANORAMALAR_ARASI_ENTEGRASYON_VERI_ALMA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MERKEZE,
            self::VALUE_MERKEZDEN,
            self::VALUE_MERKEZDEN_WEB_SERVISI_MUSTERI,
            self::VALUE_MERKEZDEN_WEB_SERVISI_FIYAT_VADE,
            self::VALUE_MERKEZDEN_WEB_SERVISI_KARSILIKLAR,
            self::VALUE_MERKEZDEN_ESY,
            self::VALUE_ESYDEN_MERKEZE,
            self::VALUE_MERKEZDEN_QUESTE,
            self::VALUE_QUESTTEN_MERKEZE,
            self::VALUE_OLE_DB_TEXTTEN_MERKEZE,
            self::VALUE_OLE_DB_MERKEZDEN_TEXTE,
            self::VALUE_HEDEF_BILGILERIN_SAPDEN_ALINMASI,
            self::VALUE_WEB_SERVICE_1,
            self::VALUE_WEB_SERVICE_2,
            self::VALUE_WEB_SERVICE_3,
            self::VALUE_WEB_SERVICE_4,
            self::VALUE_WEB_SERVICE_5,
            self::VALUE_WEB_SERVICE_6,
            self::VALUE_OLE_DB_EXCELDEN_MERKEZE,
            self::VALUE_OLE_DB_MERKEZDEN_EXCELE,
            self::VALUE_PANORAMA_RECOVERY,
            self::VALUE_PANORAMADAN_ERPYE_ONAYLI,
            self::VALUE_WMSENTEGRASYON_SABIT,
            self::VALUE_WMSENTEGRASYON_HAREKET,
            self::VALUE_RAPOR_MAIL_GONDER,
            self::VALUE_EKIPMAN_SAYIM,
            self::VALUE_PANORAMADAN_VER_SIPARISINE_PERIYODIK,
            self::VALUE_PANORAMADAN_VER_SIPARISINE_ANLIK,
            self::VALUE_PANORAMALAR_ARASI_ENTEGRASYON_MERKEZ,
            self::VALUE_PANORAMALAR_ARASI_ENTEGRASYON_VERI_ALMA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
