<?php

namespace EnumType;

/**
 * This class stands for LKS2MuhasebeKodlariTipi EnumType
 * @subpackage Enumerations
 */
class LKS2MuhasebeKodlariTipi
{
    /**
     * Constant for value 'LKS2denCek'
     * @return string 'LKS2denCek'
     */
    const VALUE_LKS_2_DEN_CEK = 'LKS2denCek';
    /**
     * Constant for value 'SabitTanimlariKullan'
     * @return string 'SabitTanimlariKullan'
     */
    const VALUE_SABIT_TANIMLARI_KULLAN = 'SabitTanimlariKullan';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LKS_2_DEN_CEK
     * @uses self::VALUE_SABIT_TANIMLARI_KULLAN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LKS_2_DEN_CEK,
            self::VALUE_SABIT_TANIMLARI_KULLAN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
