<?php

namespace EnumType;

/**
 * This class stands for clsTCPIslemYetki EnumType
 * @subpackage Enumerations
 */
class ClsTCPIslemYetki
{
    /**
     * Constant for value 'Degistirilemez'
     * @return string 'Degistirilemez'
     */
    const VALUE_DEGISTIRILEMEZ = 'Degistirilemez';
    /**
     * Constant for value 'Degistirilebilir'
     * @return string 'Degistirilebilir'
     */
    const VALUE_DEGISTIRILEBILIR = 'Degistirilebilir';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DEGISTIRILEMEZ
     * @uses self::VALUE_DEGISTIRILEBILIR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DEGISTIRILEMEZ,
            self::VALUE_DEGISTIRILEBILIR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
