<?php

namespace EnumType;

/**
 * This class stands for clsERAktarimTip EnumType
 * @subpackage Enumerations
 */
class ClsERAktarimTip
{
    /**
     * Constant for value 'Fatura'
     * @return string 'Fatura'
     */
    const VALUE_FATURA = 'Fatura';
    /**
     * Constant for value 'Siparis'
     * @return string 'Siparis'
     */
    const VALUE_SIPARIS = 'Siparis';
    /**
     * Constant for value 'Irsaliye'
     * @return string 'Irsaliye'
     */
    const VALUE_IRSALIYE = 'Irsaliye';
    /**
     * Constant for value 'Tahsilat'
     * @return string 'Tahsilat'
     */
    const VALUE_TAHSILAT = 'Tahsilat';
    /**
     * Constant for value 'DepoHareket'
     * @return string 'DepoHareket'
     */
    const VALUE_DEPO_HAREKET = 'DepoHareket';
    /**
     * Constant for value 'IsBildirim'
     * @return string 'IsBildirim'
     */
    const VALUE_IS_BILDIRIM = 'IsBildirim';
    /**
     * Constant for value 'KonsinyeIrsaliye'
     * @return string 'KonsinyeIrsaliye'
     */
    const VALUE_KONSINYE_IRSALIYE = 'KonsinyeIrsaliye';
    /**
     * Constant for value 'E_Fatura'
     * @return string 'E_Fatura'
     */
    const VALUE_E_FATURA = 'E_Fatura';
    /**
     * Constant for value 'Teslimat_Fatura'
     * @return string 'Teslimat_Fatura'
     */
    const VALUE_TESLIMAT_FATURA = 'Teslimat_Fatura';
    /**
     * Constant for value 'Teslimat_Irsaliye'
     * @return string 'Teslimat_Irsaliye'
     */
    const VALUE_TESLIMAT_IRSALIYE = 'Teslimat_Irsaliye';
    /**
     * Constant for value 'Teklif'
     * @return string 'Teklif'
     */
    const VALUE_TEKLIF = 'Teklif';
    /**
     * Constant for value 'KarsilikAyirma'
     * @return string 'KarsilikAyirma'
     */
    const VALUE_KARSILIK_AYIRMA = 'KarsilikAyirma';
    /**
     * Constant for value 'Musteri'
     * @return string 'Musteri'
     */
    const VALUE_MUSTERI = 'Musteri';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FATURA
     * @uses self::VALUE_SIPARIS
     * @uses self::VALUE_IRSALIYE
     * @uses self::VALUE_TAHSILAT
     * @uses self::VALUE_DEPO_HAREKET
     * @uses self::VALUE_IS_BILDIRIM
     * @uses self::VALUE_KONSINYE_IRSALIYE
     * @uses self::VALUE_E_FATURA
     * @uses self::VALUE_TESLIMAT_FATURA
     * @uses self::VALUE_TESLIMAT_IRSALIYE
     * @uses self::VALUE_TEKLIF
     * @uses self::VALUE_KARSILIK_AYIRMA
     * @uses self::VALUE_MUSTERI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FATURA,
            self::VALUE_SIPARIS,
            self::VALUE_IRSALIYE,
            self::VALUE_TAHSILAT,
            self::VALUE_DEPO_HAREKET,
            self::VALUE_IS_BILDIRIM,
            self::VALUE_KONSINYE_IRSALIYE,
            self::VALUE_E_FATURA,
            self::VALUE_TESLIMAT_FATURA,
            self::VALUE_TESLIMAT_IRSALIYE,
            self::VALUE_TEKLIF,
            self::VALUE_KARSILIK_AYIRMA,
            self::VALUE_MUSTERI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
