<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsServiceConfig StructType
 * @subpackage Structs
 */
class ClsServiceConfig extends AbstractStructBase
{
    /**
     * The SchedulerTimerInterval
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $SchedulerTimerInterval;
    /**
     * The QueueTimerInterval
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $QueueTimerInterval;
    /**
     * The FirmCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FirmCode;
    /**
     * The ActiveYear
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ActiveYear;
    /**
     * The SessionType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SessionType;
    /**
     * The MaxThreadCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MaxThreadCount;
    /**
     * The IsDefaultLic
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IsDefaultLic;
    /**
     * The MultiThreadSelectWaitTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MultiThreadSelectWaitTime;
    /**
     * The DataSource
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DataSource;
    /**
     * The InitialCatalog
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InitialCatalog;
    /**
     * The LicenceFirmDB
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $LicenceFirmDB;
    /**
     * The QlickViewUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $QlickViewUrl;
    /**
     * The QlickViewDocument
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $QlickViewDocument;
    /**
     * The QlickViewTicketingUser
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $QlickViewTicketingUser;
    /**
     * The QlickViewTicketingPass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $QlickViewTicketingPass;
    /**
     * The QlickViewTicketingUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $QlickViewTicketingUrl;
    /**
     * The CultureInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CultureInfo;
    /**
     * Constructor method for clsServiceConfig
     * @uses ClsServiceConfig::setSchedulerTimerInterval()
     * @uses ClsServiceConfig::setQueueTimerInterval()
     * @uses ClsServiceConfig::setFirmCode()
     * @uses ClsServiceConfig::setActiveYear()
     * @uses ClsServiceConfig::setSessionType()
     * @uses ClsServiceConfig::setMaxThreadCount()
     * @uses ClsServiceConfig::setIsDefaultLic()
     * @uses ClsServiceConfig::setMultiThreadSelectWaitTime()
     * @uses ClsServiceConfig::setDataSource()
     * @uses ClsServiceConfig::setInitialCatalog()
     * @uses ClsServiceConfig::setLicenceFirmDB()
     * @uses ClsServiceConfig::setQlickViewUrl()
     * @uses ClsServiceConfig::setQlickViewDocument()
     * @uses ClsServiceConfig::setQlickViewTicketingUser()
     * @uses ClsServiceConfig::setQlickViewTicketingPass()
     * @uses ClsServiceConfig::setQlickViewTicketingUrl()
     * @uses ClsServiceConfig::setCultureInfo()
     * @param float $schedulerTimerInterval
     * @param float $queueTimerInterval
     * @param int $firmCode
     * @param int $activeYear
     * @param string $sessionType
     * @param int $maxThreadCount
     * @param int $isDefaultLic
     * @param int $multiThreadSelectWaitTime
     * @param string $dataSource
     * @param string $initialCatalog
     * @param \ArrayType\ArrayOfString $licenceFirmDB
     * @param string $qlickViewUrl
     * @param string $qlickViewDocument
     * @param string $qlickViewTicketingUser
     * @param string $qlickViewTicketingPass
     * @param string $qlickViewTicketingUrl
     * @param string $cultureInfo
     */
    public function __construct($schedulerTimerInterval = null, $queueTimerInterval = null, $firmCode = null, $activeYear = null, $sessionType = null, $maxThreadCount = null, $isDefaultLic = null, $multiThreadSelectWaitTime = null, $dataSource = null, $initialCatalog = null, \ArrayType\ArrayOfString $licenceFirmDB = null, $qlickViewUrl = null, $qlickViewDocument = null, $qlickViewTicketingUser = null, $qlickViewTicketingPass = null, $qlickViewTicketingUrl = null, $cultureInfo = null)
    {
        $this
            ->setSchedulerTimerInterval($schedulerTimerInterval)
            ->setQueueTimerInterval($queueTimerInterval)
            ->setFirmCode($firmCode)
            ->setActiveYear($activeYear)
            ->setSessionType($sessionType)
            ->setMaxThreadCount($maxThreadCount)
            ->setIsDefaultLic($isDefaultLic)
            ->setMultiThreadSelectWaitTime($multiThreadSelectWaitTime)
            ->setDataSource($dataSource)
            ->setInitialCatalog($initialCatalog)
            ->setLicenceFirmDB($licenceFirmDB)
            ->setQlickViewUrl($qlickViewUrl)
            ->setQlickViewDocument($qlickViewDocument)
            ->setQlickViewTicketingUser($qlickViewTicketingUser)
            ->setQlickViewTicketingPass($qlickViewTicketingPass)
            ->setQlickViewTicketingUrl($qlickViewTicketingUrl)
            ->setCultureInfo($cultureInfo);
    }
    /**
     * Get SchedulerTimerInterval value
     * @return float
     */
    public function getSchedulerTimerInterval()
    {
        return $this->SchedulerTimerInterval;
    }
    /**
     * Set SchedulerTimerInterval value
     * @param float $schedulerTimerInterval
     * @return \StructType\ClsServiceConfig
     */
    public function setSchedulerTimerInterval($schedulerTimerInterval = null)
    {
        // validation for constraint: float
        if (!is_null($schedulerTimerInterval) && !(is_float($schedulerTimerInterval) || is_numeric($schedulerTimerInterval))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($schedulerTimerInterval, true), gettype($schedulerTimerInterval)), __LINE__);
        }
        $this->SchedulerTimerInterval = $schedulerTimerInterval;
        return $this;
    }
    /**
     * Get QueueTimerInterval value
     * @return float
     */
    public function getQueueTimerInterval()
    {
        return $this->QueueTimerInterval;
    }
    /**
     * Set QueueTimerInterval value
     * @param float $queueTimerInterval
     * @return \StructType\ClsServiceConfig
     */
    public function setQueueTimerInterval($queueTimerInterval = null)
    {
        // validation for constraint: float
        if (!is_null($queueTimerInterval) && !(is_float($queueTimerInterval) || is_numeric($queueTimerInterval))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($queueTimerInterval, true), gettype($queueTimerInterval)), __LINE__);
        }
        $this->QueueTimerInterval = $queueTimerInterval;
        return $this;
    }
    /**
     * Get FirmCode value
     * @return int
     */
    public function getFirmCode()
    {
        return $this->FirmCode;
    }
    /**
     * Set FirmCode value
     * @param int $firmCode
     * @return \StructType\ClsServiceConfig
     */
    public function setFirmCode($firmCode = null)
    {
        // validation for constraint: int
        if (!is_null($firmCode) && !(is_int($firmCode) || ctype_digit($firmCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($firmCode, true), gettype($firmCode)), __LINE__);
        }
        $this->FirmCode = $firmCode;
        return $this;
    }
    /**
     * Get ActiveYear value
     * @return int
     */
    public function getActiveYear()
    {
        return $this->ActiveYear;
    }
    /**
     * Set ActiveYear value
     * @param int $activeYear
     * @return \StructType\ClsServiceConfig
     */
    public function setActiveYear($activeYear = null)
    {
        // validation for constraint: int
        if (!is_null($activeYear) && !(is_int($activeYear) || ctype_digit($activeYear))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($activeYear, true), gettype($activeYear)), __LINE__);
        }
        $this->ActiveYear = $activeYear;
        return $this;
    }
    /**
     * Get SessionType value
     * @return string
     */
    public function getSessionType()
    {
        return $this->SessionType;
    }
    /**
     * Set SessionType value
     * @uses \EnumType\ServiceSessionType::valueIsValid()
     * @uses \EnumType\ServiceSessionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sessionType
     * @return \StructType\ClsServiceConfig
     */
    public function setSessionType($sessionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceSessionType::valueIsValid($sessionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ServiceSessionType', is_array($sessionType) ? implode(', ', $sessionType) : var_export($sessionType, true), implode(', ', \EnumType\ServiceSessionType::getValidValues())), __LINE__);
        }
        $this->SessionType = $sessionType;
        return $this;
    }
    /**
     * Get MaxThreadCount value
     * @return int
     */
    public function getMaxThreadCount()
    {
        return $this->MaxThreadCount;
    }
    /**
     * Set MaxThreadCount value
     * @param int $maxThreadCount
     * @return \StructType\ClsServiceConfig
     */
    public function setMaxThreadCount($maxThreadCount = null)
    {
        // validation for constraint: int
        if (!is_null($maxThreadCount) && !(is_int($maxThreadCount) || ctype_digit($maxThreadCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxThreadCount, true), gettype($maxThreadCount)), __LINE__);
        }
        $this->MaxThreadCount = $maxThreadCount;
        return $this;
    }
    /**
     * Get IsDefaultLic value
     * @return int
     */
    public function getIsDefaultLic()
    {
        return $this->IsDefaultLic;
    }
    /**
     * Set IsDefaultLic value
     * @param int $isDefaultLic
     * @return \StructType\ClsServiceConfig
     */
    public function setIsDefaultLic($isDefaultLic = null)
    {
        // validation for constraint: int
        if (!is_null($isDefaultLic) && !(is_int($isDefaultLic) || ctype_digit($isDefaultLic))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($isDefaultLic, true), gettype($isDefaultLic)), __LINE__);
        }
        $this->IsDefaultLic = $isDefaultLic;
        return $this;
    }
    /**
     * Get MultiThreadSelectWaitTime value
     * @return int
     */
    public function getMultiThreadSelectWaitTime()
    {
        return $this->MultiThreadSelectWaitTime;
    }
    /**
     * Set MultiThreadSelectWaitTime value
     * @param int $multiThreadSelectWaitTime
     * @return \StructType\ClsServiceConfig
     */
    public function setMultiThreadSelectWaitTime($multiThreadSelectWaitTime = null)
    {
        // validation for constraint: int
        if (!is_null($multiThreadSelectWaitTime) && !(is_int($multiThreadSelectWaitTime) || ctype_digit($multiThreadSelectWaitTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($multiThreadSelectWaitTime, true), gettype($multiThreadSelectWaitTime)), __LINE__);
        }
        $this->MultiThreadSelectWaitTime = $multiThreadSelectWaitTime;
        return $this;
    }
    /**
     * Get DataSource value
     * @return string|null
     */
    public function getDataSource()
    {
        return $this->DataSource;
    }
    /**
     * Set DataSource value
     * @param string $dataSource
     * @return \StructType\ClsServiceConfig
     */
    public function setDataSource($dataSource = null)
    {
        // validation for constraint: string
        if (!is_null($dataSource) && !is_string($dataSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataSource, true), gettype($dataSource)), __LINE__);
        }
        $this->DataSource = $dataSource;
        return $this;
    }
    /**
     * Get InitialCatalog value
     * @return string|null
     */
    public function getInitialCatalog()
    {
        return $this->InitialCatalog;
    }
    /**
     * Set InitialCatalog value
     * @param string $initialCatalog
     * @return \StructType\ClsServiceConfig
     */
    public function setInitialCatalog($initialCatalog = null)
    {
        // validation for constraint: string
        if (!is_null($initialCatalog) && !is_string($initialCatalog)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($initialCatalog, true), gettype($initialCatalog)), __LINE__);
        }
        $this->InitialCatalog = $initialCatalog;
        return $this;
    }
    /**
     * Get LicenceFirmDB value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getLicenceFirmDB()
    {
        return $this->LicenceFirmDB;
    }
    /**
     * Set LicenceFirmDB value
     * @param \ArrayType\ArrayOfString $licenceFirmDB
     * @return \StructType\ClsServiceConfig
     */
    public function setLicenceFirmDB(\ArrayType\ArrayOfString $licenceFirmDB = null)
    {
        $this->LicenceFirmDB = $licenceFirmDB;
        return $this;
    }
    /**
     * Get QlickViewUrl value
     * @return string|null
     */
    public function getQlickViewUrl()
    {
        return $this->QlickViewUrl;
    }
    /**
     * Set QlickViewUrl value
     * @param string $qlickViewUrl
     * @return \StructType\ClsServiceConfig
     */
    public function setQlickViewUrl($qlickViewUrl = null)
    {
        // validation for constraint: string
        if (!is_null($qlickViewUrl) && !is_string($qlickViewUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qlickViewUrl, true), gettype($qlickViewUrl)), __LINE__);
        }
        $this->QlickViewUrl = $qlickViewUrl;
        return $this;
    }
    /**
     * Get QlickViewDocument value
     * @return string|null
     */
    public function getQlickViewDocument()
    {
        return $this->QlickViewDocument;
    }
    /**
     * Set QlickViewDocument value
     * @param string $qlickViewDocument
     * @return \StructType\ClsServiceConfig
     */
    public function setQlickViewDocument($qlickViewDocument = null)
    {
        // validation for constraint: string
        if (!is_null($qlickViewDocument) && !is_string($qlickViewDocument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qlickViewDocument, true), gettype($qlickViewDocument)), __LINE__);
        }
        $this->QlickViewDocument = $qlickViewDocument;
        return $this;
    }
    /**
     * Get QlickViewTicketingUser value
     * @return string|null
     */
    public function getQlickViewTicketingUser()
    {
        return $this->QlickViewTicketingUser;
    }
    /**
     * Set QlickViewTicketingUser value
     * @param string $qlickViewTicketingUser
     * @return \StructType\ClsServiceConfig
     */
    public function setQlickViewTicketingUser($qlickViewTicketingUser = null)
    {
        // validation for constraint: string
        if (!is_null($qlickViewTicketingUser) && !is_string($qlickViewTicketingUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qlickViewTicketingUser, true), gettype($qlickViewTicketingUser)), __LINE__);
        }
        $this->QlickViewTicketingUser = $qlickViewTicketingUser;
        return $this;
    }
    /**
     * Get QlickViewTicketingPass value
     * @return string|null
     */
    public function getQlickViewTicketingPass()
    {
        return $this->QlickViewTicketingPass;
    }
    /**
     * Set QlickViewTicketingPass value
     * @param string $qlickViewTicketingPass
     * @return \StructType\ClsServiceConfig
     */
    public function setQlickViewTicketingPass($qlickViewTicketingPass = null)
    {
        // validation for constraint: string
        if (!is_null($qlickViewTicketingPass) && !is_string($qlickViewTicketingPass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qlickViewTicketingPass, true), gettype($qlickViewTicketingPass)), __LINE__);
        }
        $this->QlickViewTicketingPass = $qlickViewTicketingPass;
        return $this;
    }
    /**
     * Get QlickViewTicketingUrl value
     * @return string|null
     */
    public function getQlickViewTicketingUrl()
    {
        return $this->QlickViewTicketingUrl;
    }
    /**
     * Set QlickViewTicketingUrl value
     * @param string $qlickViewTicketingUrl
     * @return \StructType\ClsServiceConfig
     */
    public function setQlickViewTicketingUrl($qlickViewTicketingUrl = null)
    {
        // validation for constraint: string
        if (!is_null($qlickViewTicketingUrl) && !is_string($qlickViewTicketingUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qlickViewTicketingUrl, true), gettype($qlickViewTicketingUrl)), __LINE__);
        }
        $this->QlickViewTicketingUrl = $qlickViewTicketingUrl;
        return $this;
    }
    /**
     * Get CultureInfo value
     * @return string|null
     */
    public function getCultureInfo()
    {
        return $this->CultureInfo;
    }
    /**
     * Set CultureInfo value
     * @param string $cultureInfo
     * @return \StructType\ClsServiceConfig
     */
    public function setCultureInfo($cultureInfo = null)
    {
        // validation for constraint: string
        if (!is_null($cultureInfo) && !is_string($cultureInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cultureInfo, true), gettype($cultureInfo)), __LINE__);
        }
        $this->CultureInfo = $cultureInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsServiceConfig
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
