<?php

namespace EnumType;

/**
 * This class stands for GorevKaynak EnumType
 * @subpackage Enumerations
 */
class GorevKaynak
{
    /**
     * Constant for value 'GorevYonetici'
     * @return string 'GorevYonetici'
     */
    const VALUE_GOREV_YONETICI = 'GorevYonetici';
    /**
     * Constant for value 'Uygulama'
     * @return string 'Uygulama'
     */
    const VALUE_UYGULAMA = 'Uygulama';
    /**
     * Constant for value 'WebService'
     * @return string 'WebService'
     */
    const VALUE_WEB_SERVICE = 'WebService';
    /**
     * Constant for value 'ElTerminali'
     * @return string 'ElTerminali'
     */
    const VALUE_EL_TERMINALI = 'ElTerminali';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GOREV_YONETICI
     * @uses self::VALUE_UYGULAMA
     * @uses self::VALUE_WEB_SERVICE
     * @uses self::VALUE_EL_TERMINALI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GOREV_YONETICI,
            self::VALUE_UYGULAMA,
            self::VALUE_WEB_SERVICE,
            self::VALUE_EL_TERMINALI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
