<?php

namespace EnumType;

/**
 * This class stands for clsERSeriControlBelgeTur EnumType
 * @subpackage Enumerations
 */
class ClsERSeriControlBelgeTur
{
    /**
     * Constant for value 'DepodanCikis'
     * @return string 'DepodanCikis'
     */
    const VALUE_DEPODAN_CIKIS = 'DepodanCikis';
    /**
     * Constant for value 'DepoyaGiris'
     * @return string 'DepoyaGiris'
     */
    const VALUE_DEPOYA_GIRIS = 'DepoyaGiris';
    /**
     * Constant for value 'DepoyaGirisIade'
     * @return string 'DepoyaGirisIade'
     */
    const VALUE_DEPOYA_GIRIS_IADE = 'DepoyaGirisIade';
    /**
     * Constant for value 'SonHareket'
     * @return string 'SonHareket'
     */
    const VALUE_SON_HAREKET = 'SonHareket';
    /**
     * Constant for value 'BelgeDetayKontrol'
     * @return string 'BelgeDetayKontrol'
     */
    const VALUE_BELGE_DETAY_KONTROL = 'BelgeDetayKontrol';
    /**
     * Constant for value 'DepodanCikisIade'
     * @return string 'DepodanCikisIade'
     */
    const VALUE_DEPODAN_CIKIS_IADE = 'DepodanCikisIade';
    /**
     * Constant for value 'KonsinyeIrsaliyeAlis'
     * @return string 'KonsinyeIrsaliyeAlis'
     */
    const VALUE_KONSINYE_IRSALIYE_ALIS = 'KonsinyeIrsaliyeAlis';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DEPODAN_CIKIS
     * @uses self::VALUE_DEPOYA_GIRIS
     * @uses self::VALUE_DEPOYA_GIRIS_IADE
     * @uses self::VALUE_SON_HAREKET
     * @uses self::VALUE_BELGE_DETAY_KONTROL
     * @uses self::VALUE_DEPODAN_CIKIS_IADE
     * @uses self::VALUE_KONSINYE_IRSALIYE_ALIS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DEPODAN_CIKIS,
            self::VALUE_DEPOYA_GIRIS,
            self::VALUE_DEPOYA_GIRIS_IADE,
            self::VALUE_SON_HAREKET,
            self::VALUE_BELGE_DETAY_KONTROL,
            self::VALUE_DEPODAN_CIKIS_IADE,
            self::VALUE_KONSINYE_IRSALIYE_ALIS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
