<?php

namespace EnumType;

/**
 * This class stands for clsERSTCalismaTipi EnumType
 * @subpackage Enumerations
 */
class ClsERSTCalismaTipi
{
    /**
     * Constant for value 'Soguk'
     * @return string 'Soguk'
     */
    const VALUE_SOGUK = 'Soguk';
    /**
     * Constant for value 'Sicak'
     * @return string 'Sicak'
     */
    const VALUE_SICAK = 'Sicak';
    /**
     * Constant for value 'Karma'
     * @return string 'Karma'
     */
    const VALUE_KARMA = 'Karma';
    /**
     * Constant for value 'Depo'
     * @return string 'Depo'
     */
    const VALUE_DEPO = 'Depo';
    /**
     * Constant for value 'TuccarSicak'
     * @return string 'TuccarSicak'
     */
    const VALUE_TUCCAR_SICAK = 'TuccarSicak';
    /**
     * Constant for value 'TuccarKarma'
     * @return string 'TuccarKarma'
     */
    const VALUE_TUCCAR_KARMA = 'TuccarKarma';
    /**
     * Constant for value 'Dagitici'
     * @return string 'Dagitici'
     */
    const VALUE_DAGITICI = 'Dagitici';
    /**
     * Constant for value 'SatisYoneticisi'
     * @return string 'SatisYoneticisi'
     */
    const VALUE_SATIS_YONETICISI = 'SatisYoneticisi';
    /**
     * Constant for value 'CagriMerkezi'
     * @return string 'CagriMerkezi'
     */
    const VALUE_CAGRI_MERKEZI = 'CagriMerkezi';
    /**
     * Constant for value 'Servis'
     * @return string 'Servis'
     */
    const VALUE_SERVIS = 'Servis';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SOGUK
     * @uses self::VALUE_SICAK
     * @uses self::VALUE_KARMA
     * @uses self::VALUE_DEPO
     * @uses self::VALUE_TUCCAR_SICAK
     * @uses self::VALUE_TUCCAR_KARMA
     * @uses self::VALUE_DAGITICI
     * @uses self::VALUE_SATIS_YONETICISI
     * @uses self::VALUE_CAGRI_MERKEZI
     * @uses self::VALUE_SERVIS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SOGUK,
            self::VALUE_SICAK,
            self::VALUE_KARMA,
            self::VALUE_DEPO,
            self::VALUE_TUCCAR_SICAK,
            self::VALUE_TUCCAR_KARMA,
            self::VALUE_DAGITICI,
            self::VALUE_SATIS_YONETICISI,
            self::VALUE_CAGRI_MERKEZI,
            self::VALUE_SERVIS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
