<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsResult StructType
 * @subpackage Structs
 */
class ClsResult extends AbstractStructBase
{
    /**
     * The ResultType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ResultType;
    /**
     * The ResultExceptionCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ResultExceptionCode;
    /**
     * The ResultString
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResultString;
    /**
     * The CreatedDispatchIDS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt1
     */
    public $CreatedDispatchIDS;
    /**
     * The CreatedPartialIds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt1
     */
    public $CreatedPartialIds;
    /**
     * The CreatedInvoiceIds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt1
     */
    public $CreatedInvoiceIds;
    /**
     * Constructor method for clsResult
     * @uses ClsResult::setResultType()
     * @uses ClsResult::setResultExceptionCode()
     * @uses ClsResult::setResultString()
     * @uses ClsResult::setCreatedDispatchIDS()
     * @uses ClsResult::setCreatedPartialIds()
     * @uses ClsResult::setCreatedInvoiceIds()
     * @param string $resultType
     * @param string $resultExceptionCode
     * @param string $resultString
     * @param \ArrayType\ArrayOfInt1 $createdDispatchIDS
     * @param \ArrayType\ArrayOfInt1 $createdPartialIds
     * @param \ArrayType\ArrayOfInt1 $createdInvoiceIds
     */
    public function __construct($resultType = null, $resultExceptionCode = null, $resultString = null, \ArrayType\ArrayOfInt1 $createdDispatchIDS = null, \ArrayType\ArrayOfInt1 $createdPartialIds = null, \ArrayType\ArrayOfInt1 $createdInvoiceIds = null)
    {
        $this
            ->setResultType($resultType)
            ->setResultExceptionCode($resultExceptionCode)
            ->setResultString($resultString)
            ->setCreatedDispatchIDS($createdDispatchIDS)
            ->setCreatedPartialIds($createdPartialIds)
            ->setCreatedInvoiceIds($createdInvoiceIds);
    }
    /**
     * Get ResultType value
     * @return string
     */
    public function getResultType()
    {
        return $this->ResultType;
    }
    /**
     * Set ResultType value
     * @uses \EnumType\ClsERBelgeSonucTip::valueIsValid()
     * @uses \EnumType\ClsERBelgeSonucTip::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resultType
     * @return \StructType\ClsResult
     */
    public function setResultType($resultType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ClsERBelgeSonucTip::valueIsValid($resultType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ClsERBelgeSonucTip', is_array($resultType) ? implode(', ', $resultType) : var_export($resultType, true), implode(', ', \EnumType\ClsERBelgeSonucTip::getValidValues())), __LINE__);
        }
        $this->ResultType = $resultType;
        return $this;
    }
    /**
     * Get ResultExceptionCode value
     * @return string
     */
    public function getResultExceptionCode()
    {
        return $this->ResultExceptionCode;
    }
    /**
     * Set ResultExceptionCode value
     * @uses \EnumType\ClsResultExceptionCode::valueIsValid()
     * @uses \EnumType\ClsResultExceptionCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resultExceptionCode
     * @return \StructType\ClsResult
     */
    public function setResultExceptionCode($resultExceptionCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ClsResultExceptionCode::valueIsValid($resultExceptionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ClsResultExceptionCode', is_array($resultExceptionCode) ? implode(', ', $resultExceptionCode) : var_export($resultExceptionCode, true), implode(', ', \EnumType\ClsResultExceptionCode::getValidValues())), __LINE__);
        }
        $this->ResultExceptionCode = $resultExceptionCode;
        return $this;
    }
    /**
     * Get ResultString value
     * @return string|null
     */
    public function getResultString()
    {
        return $this->ResultString;
    }
    /**
     * Set ResultString value
     * @param string $resultString
     * @return \StructType\ClsResult
     */
    public function setResultString($resultString = null)
    {
        // validation for constraint: string
        if (!is_null($resultString) && !is_string($resultString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultString, true), gettype($resultString)), __LINE__);
        }
        $this->ResultString = $resultString;
        return $this;
    }
    /**
     * Get CreatedDispatchIDS value
     * @return \ArrayType\ArrayOfInt1|null
     */
    public function getCreatedDispatchIDS()
    {
        return $this->CreatedDispatchIDS;
    }
    /**
     * Set CreatedDispatchIDS value
     * @param \ArrayType\ArrayOfInt1 $createdDispatchIDS
     * @return \StructType\ClsResult
     */
    public function setCreatedDispatchIDS(\ArrayType\ArrayOfInt1 $createdDispatchIDS = null)
    {
        $this->CreatedDispatchIDS = $createdDispatchIDS;
        return $this;
    }
    /**
     * Get CreatedPartialIds value
     * @return \ArrayType\ArrayOfInt1|null
     */
    public function getCreatedPartialIds()
    {
        return $this->CreatedPartialIds;
    }
    /**
     * Set CreatedPartialIds value
     * @param \ArrayType\ArrayOfInt1 $createdPartialIds
     * @return \StructType\ClsResult
     */
    public function setCreatedPartialIds(\ArrayType\ArrayOfInt1 $createdPartialIds = null)
    {
        $this->CreatedPartialIds = $createdPartialIds;
        return $this;
    }
    /**
     * Get CreatedInvoiceIds value
     * @return \ArrayType\ArrayOfInt1|null
     */
    public function getCreatedInvoiceIds()
    {
        return $this->CreatedInvoiceIds;
    }
    /**
     * Set CreatedInvoiceIds value
     * @param \ArrayType\ArrayOfInt1 $createdInvoiceIds
     * @return \StructType\ClsResult
     */
    public function setCreatedInvoiceIds(\ArrayType\ArrayOfInt1 $createdInvoiceIds = null)
    {
        $this->CreatedInvoiceIds = $createdInvoiceIds;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
