<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsMusteriGrup StructType
 * @subpackage Structs
 */
class ClsMusteriGrup extends ClsEntity
{
    /**
     * The DistKod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DistKod;
    /**
     * The UygulamaYeri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $UygulamaYeri;
    /**
     * The TeklikKontrol
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TeklikKontrol;
    /**
     * The Kod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Kod;
    /**
     * The Ad
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ad;
    /**
     * The Referans
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Referans;
    /**
     * The GrupKirilimKod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GrupKirilimKod;
    /**
     * Constructor method for clsMusteriGrup
     * @uses ClsMusteriGrup::setDistKod()
     * @uses ClsMusteriGrup::setUygulamaYeri()
     * @uses ClsMusteriGrup::setTeklikKontrol()
     * @uses ClsMusteriGrup::setKod()
     * @uses ClsMusteriGrup::setAd()
     * @uses ClsMusteriGrup::setReferans()
     * @uses ClsMusteriGrup::setGrupKirilimKod()
     * @param int $distKod
     * @param string $uygulamaYeri
     * @param string $teklikKontrol
     * @param string $kod
     * @param string $ad
     * @param string $referans
     * @param string $grupKirilimKod
     */
    public function __construct($distKod = null, $uygulamaYeri = null, $teklikKontrol = null, $kod = null, $ad = null, $referans = null, $grupKirilimKod = null)
    {
        $this
            ->setDistKod($distKod)
            ->setUygulamaYeri($uygulamaYeri)
            ->setTeklikKontrol($teklikKontrol)
            ->setKod($kod)
            ->setAd($ad)
            ->setReferans($referans)
            ->setGrupKirilimKod($grupKirilimKod);
    }
    /**
     * Get DistKod value
     * @return int
     */
    public function getDistKod()
    {
        return $this->DistKod;
    }
    /**
     * Set DistKod value
     * @param int $distKod
     * @return \StructType\ClsMusteriGrup
     */
    public function setDistKod($distKod = null)
    {
        // validation for constraint: int
        if (!is_null($distKod) && !(is_int($distKod) || ctype_digit($distKod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($distKod, true), gettype($distKod)), __LINE__);
        }
        $this->DistKod = $distKod;
        return $this;
    }
    /**
     * Get UygulamaYeri value
     * @return string
     */
    public function getUygulamaYeri()
    {
        return $this->UygulamaYeri;
    }
    /**
     * Set UygulamaYeri value
     * @param string $uygulamaYeri
     * @return \StructType\ClsMusteriGrup
     */
    public function setUygulamaYeri($uygulamaYeri = null)
    {
        // validation for constraint: string
        if (!is_null($uygulamaYeri) && !is_string($uygulamaYeri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uygulamaYeri, true), gettype($uygulamaYeri)), __LINE__);
        }
        $this->UygulamaYeri = $uygulamaYeri;
        return $this;
    }
    /**
     * Get TeklikKontrol value
     * @return string
     */
    public function getTeklikKontrol()
    {
        return $this->TeklikKontrol;
    }
    /**
     * Set TeklikKontrol value
     * @param string $teklikKontrol
     * @return \StructType\ClsMusteriGrup
     */
    public function setTeklikKontrol($teklikKontrol = null)
    {
        // validation for constraint: string
        if (!is_null($teklikKontrol) && !is_string($teklikKontrol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($teklikKontrol, true), gettype($teklikKontrol)), __LINE__);
        }
        $this->TeklikKontrol = $teklikKontrol;
        return $this;
    }
    /**
     * Get Kod value
     * @return string|null
     */
    public function getKod()
    {
        return $this->Kod;
    }
    /**
     * Set Kod value
     * @param string $kod
     * @return \StructType\ClsMusteriGrup
     */
    public function setKod($kod = null)
    {
        // validation for constraint: string
        if (!is_null($kod) && !is_string($kod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kod, true), gettype($kod)), __LINE__);
        }
        $this->Kod = $kod;
        return $this;
    }
    /**
     * Get Ad value
     * @return string|null
     */
    public function getAd()
    {
        return $this->Ad;
    }
    /**
     * Set Ad value
     * @param string $ad
     * @return \StructType\ClsMusteriGrup
     */
    public function setAd($ad = null)
    {
        // validation for constraint: string
        if (!is_null($ad) && !is_string($ad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad, true), gettype($ad)), __LINE__);
        }
        $this->Ad = $ad;
        return $this;
    }
    /**
     * Get Referans value
     * @return string|null
     */
    public function getReferans()
    {
        return $this->Referans;
    }
    /**
     * Set Referans value
     * @param string $referans
     * @return \StructType\ClsMusteriGrup
     */
    public function setReferans($referans = null)
    {
        // validation for constraint: string
        if (!is_null($referans) && !is_string($referans)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referans, true), gettype($referans)), __LINE__);
        }
        $this->Referans = $referans;
        return $this;
    }
    /**
     * Get GrupKirilimKod value
     * @return string|null
     */
    public function getGrupKirilimKod()
    {
        return $this->GrupKirilimKod;
    }
    /**
     * Set GrupKirilimKod value
     * @param string $grupKirilimKod
     * @return \StructType\ClsMusteriGrup
     */
    public function setGrupKirilimKod($grupKirilimKod = null)
    {
        // validation for constraint: string
        if (!is_null($grupKirilimKod) && !is_string($grupKirilimKod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($grupKirilimKod, true), gettype($grupKirilimKod)), __LINE__);
        }
        $this->GrupKirilimKod = $grupKirilimKod;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsMusteriGrup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
