<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsDistMailKriter StructType
 * @subpackage Structs
 */
class ClsDistMailKriter extends AbstractStructBase
{
    /**
     * The GorecSonucMailStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $GorecSonucMailStatus;
    /**
     * The MailAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MailAddress;
    /**
     * Constructor method for clsDistMailKriter
     * @uses ClsDistMailKriter::setGorecSonucMailStatus()
     * @uses ClsDistMailKriter::setMailAddress()
     * @param string $gorecSonucMailStatus
     * @param string $mailAddress
     */
    public function __construct($gorecSonucMailStatus = null, $mailAddress = null)
    {
        $this
            ->setGorecSonucMailStatus($gorecSonucMailStatus)
            ->setMailAddress($mailAddress);
    }
    /**
     * Get GorecSonucMailStatus value
     * @return string
     */
    public function getGorecSonucMailStatus()
    {
        return $this->GorecSonucMailStatus;
    }
    /**
     * Set GorecSonucMailStatus value
     * @uses \EnumType\ClsGorevSonucSendMailType::valueIsValid()
     * @uses \EnumType\ClsGorevSonucSendMailType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gorecSonucMailStatus
     * @return \StructType\ClsDistMailKriter
     */
    public function setGorecSonucMailStatus($gorecSonucMailStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ClsGorevSonucSendMailType::valueIsValid($gorecSonucMailStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ClsGorevSonucSendMailType', is_array($gorecSonucMailStatus) ? implode(', ', $gorecSonucMailStatus) : var_export($gorecSonucMailStatus, true), implode(', ', \EnumType\ClsGorevSonucSendMailType::getValidValues())), __LINE__);
        }
        $this->GorecSonucMailStatus = $gorecSonucMailStatus;
        return $this;
    }
    /**
     * Get MailAddress value
     * @return string|null
     */
    public function getMailAddress()
    {
        return $this->MailAddress;
    }
    /**
     * Set MailAddress value
     * @param string $mailAddress
     * @return \StructType\ClsDistMailKriter
     */
    public function setMailAddress($mailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($mailAddress) && !is_string($mailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailAddress, true), gettype($mailAddress)), __LINE__);
        }
        $this->MailAddress = $mailAddress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsDistMailKriter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
