<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsBilgiKriter StructType
 * @subpackage Structs
 */
class ClsBilgiKriter extends ClsEntity
{
    /**
     * The Kod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Kod;
    /**
     * The BaslangicTarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $BaslangicTarihi;
    /**
     * The BitisTarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $BitisTarihi;
    /**
     * The PaketTip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PaketTip;
    /**
     * The PaketKod
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $PaketKod;
    /**
     * Constructor method for clsBilgiKriter
     * @uses ClsBilgiKriter::setKod()
     * @uses ClsBilgiKriter::setBaslangicTarihi()
     * @uses ClsBilgiKriter::setBitisTarihi()
     * @uses ClsBilgiKriter::setPaketTip()
     * @uses ClsBilgiKriter::setPaketKod()
     * @param int $kod
     * @param string $baslangicTarihi
     * @param string $bitisTarihi
     * @param string $paketTip
     * @param string $paketKod
     */
    public function __construct($kod = null, $baslangicTarihi = null, $bitisTarihi = null, $paketTip = null, $paketKod = null)
    {
        $this
            ->setKod($kod)
            ->setBaslangicTarihi($baslangicTarihi)
            ->setBitisTarihi($bitisTarihi)
            ->setPaketTip($paketTip)
            ->setPaketKod($paketKod);
    }
    /**
     * Get Kod value
     * @return int
     */
    public function getKod()
    {
        return $this->Kod;
    }
    /**
     * Set Kod value
     * @param int $kod
     * @return \StructType\ClsBilgiKriter
     */
    public function setKod($kod = null)
    {
        // validation for constraint: int
        if (!is_null($kod) && !(is_int($kod) || ctype_digit($kod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kod, true), gettype($kod)), __LINE__);
        }
        $this->Kod = $kod;
        return $this;
    }
    /**
     * Get BaslangicTarihi value
     * @return string
     */
    public function getBaslangicTarihi()
    {
        return $this->BaslangicTarihi;
    }
    /**
     * Set BaslangicTarihi value
     * @param string $baslangicTarihi
     * @return \StructType\ClsBilgiKriter
     */
    public function setBaslangicTarihi($baslangicTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($baslangicTarihi) && !is_string($baslangicTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baslangicTarihi, true), gettype($baslangicTarihi)), __LINE__);
        }
        $this->BaslangicTarihi = $baslangicTarihi;
        return $this;
    }
    /**
     * Get BitisTarihi value
     * @return string
     */
    public function getBitisTarihi()
    {
        return $this->BitisTarihi;
    }
    /**
     * Set BitisTarihi value
     * @param string $bitisTarihi
     * @return \StructType\ClsBilgiKriter
     */
    public function setBitisTarihi($bitisTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($bitisTarihi) && !is_string($bitisTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bitisTarihi, true), gettype($bitisTarihi)), __LINE__);
        }
        $this->BitisTarihi = $bitisTarihi;
        return $this;
    }
    /**
     * Get PaketTip value
     * @return string
     */
    public function getPaketTip()
    {
        return $this->PaketTip;
    }
    /**
     * Set PaketTip value
     * @param string $paketTip
     * @return \StructType\ClsBilgiKriter
     */
    public function setPaketTip($paketTip = null)
    {
        // validation for constraint: string
        if (!is_null($paketTip) && !is_string($paketTip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paketTip, true), gettype($paketTip)), __LINE__);
        }
        $this->PaketTip = $paketTip;
        return $this;
    }
    /**
     * Get PaketKod value
     * @return string
     */
    public function getPaketKod()
    {
        return $this->PaketKod;
    }
    /**
     * Set PaketKod value
     * @param string $paketKod
     * @return \StructType\ClsBilgiKriter
     */
    public function setPaketKod($paketKod = null)
    {
        // validation for constraint: string
        if (!is_null($paketKod) && !is_string($paketKod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paketKod, true), gettype($paketKod)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($paketKod) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $paketKod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($paketKod, true)), __LINE__);
        }
        $this->PaketKod = $paketKod;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsBilgiKriter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
