<?php

namespace EnumType;

/**
 * This class stands for clsERSeriTakipTip EnumType
 * @subpackage Enumerations
 */
class ClsERSeriTakipTip
{
    /**
     * Constant for value 'Sayisal'
     * @return string 'Sayisal'
     */
    const VALUE_SAYISAL = 'Sayisal';
    /**
     * Constant for value 'Metin'
     * @return string 'Metin'
     */
    const VALUE_METIN = 'Metin';
    /**
     * Constant for value 'HepsiSayisalOncelikli'
     * @return string 'HepsiSayisalOncelikli'
     */
    const VALUE_HEPSI_SAYISAL_ONCELIKLI = 'HepsiSayisalOncelikli';
    /**
     * Constant for value 'HepsiMetinOncelikli'
     * @return string 'HepsiMetinOncelikli'
     */
    const VALUE_HEPSI_METIN_ONCELIKLI = 'HepsiMetinOncelikli';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SAYISAL
     * @uses self::VALUE_METIN
     * @uses self::VALUE_HEPSI_SAYISAL_ONCELIKLI
     * @uses self::VALUE_HEPSI_METIN_ONCELIKLI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SAYISAL,
            self::VALUE_METIN,
            self::VALUE_HEPSI_SAYISAL_ONCELIKLI,
            self::VALUE_HEPSI_METIN_ONCELIKLI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
