<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfClsResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfClsResult extends AbstractStructArrayBase
{
    /**
     * The clsResult
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ClsResult[]
     */
    public $clsResult;
    /**
     * Constructor method for ArrayOfClsResult
     * @uses ArrayOfClsResult::setClsResult()
     * @param \StructType\ClsResult[] $clsResult
     */
    public function __construct(array $clsResult = array())
    {
        $this
            ->setClsResult($clsResult);
    }
    /**
     * Get clsResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ClsResult[]|null
     */
    public function getClsResult()
    {
        return isset($this->clsResult) ? $this->clsResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setClsResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClsResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClsResultForArrayConstraintsFromSetClsResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfClsResultClsResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfClsResultClsResultItem instanceof \StructType\ClsResult) {
                $invalidValues[] = is_object($arrayOfClsResultClsResultItem) ? get_class($arrayOfClsResultClsResultItem) : sprintf('%s(%s)', gettype($arrayOfClsResultClsResultItem), var_export($arrayOfClsResultClsResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The clsResult property can only contain items of type \StructType\ClsResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set clsResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ClsResult[] $clsResult
     * @return \ArrayType\ArrayOfClsResult
     */
    public function setClsResult(array $clsResult = array())
    {
        // validation for constraint: array
        if ('' !== ($clsResultArrayErrorMessage = self::validateClsResultForArrayConstraintsFromSetClsResult($clsResult))) {
            throw new \InvalidArgumentException($clsResultArrayErrorMessage, __LINE__);
        }
        if (is_null($clsResult) || (is_array($clsResult) && empty($clsResult))) {
            unset($this->clsResult);
        } else {
            $this->clsResult = $clsResult;
        }
        return $this;
    }
    /**
     * Add item to clsResult value
     * @throws \InvalidArgumentException
     * @param \StructType\ClsResult $item
     * @return \ArrayType\ArrayOfClsResult
     */
    public function addToClsResult(\StructType\ClsResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ClsResult) {
            throw new \InvalidArgumentException(sprintf('The clsResult property can only contain items of type \StructType\ClsResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->clsResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ClsResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ClsResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ClsResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ClsResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ClsResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string clsResult
     */
    public function getAttributeName()
    {
        return 'clsResult';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfClsResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
