<?php

namespace EnumType;

/**
 * This class stands for ServiceSessionType EnumType
 * @subpackage Enumerations
 */
class ServiceSessionType
{
    /**
     * Constant for value 'NetworkService'
     * @return string 'NetworkService'
     */
    const VALUE_NETWORK_SERVICE = 'NetworkService';
    /**
     * Constant for value 'LocalSystem'
     * @return string 'LocalSystem'
     */
    const VALUE_LOCAL_SYSTEM = 'LocalSystem';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NETWORK_SERVICE
     * @uses self::VALUE_LOCAL_SYSTEM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NETWORK_SERVICE,
            self::VALUE_LOCAL_SYSTEM,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
