<?php

namespace EnumType;

/**
 * This class stands for clsERSeriKontrolTipi EnumType
 * @subpackage Enumerations
 */
class ClsERSeriKontrolTipi
{
    /**
     * Constant for value 'SeriYok'
     * @return string 'SeriYok'
     */
    const VALUE_SERI_YOK = 'SeriYok';
    /**
     * Constant for value 'SeriVar'
     * @return string 'SeriVar'
     */
    const VALUE_SERI_VAR = 'SeriVar';
    /**
     * Constant for value 'SeriVarKontrolsuz'
     * @return string 'SeriVarKontrolsuz'
     */
    const VALUE_SERI_VAR_KONTROLSUZ = 'SeriVarKontrolsuz';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SERI_YOK
     * @uses self::VALUE_SERI_VAR
     * @uses self::VALUE_SERI_VAR_KONTROLSUZ
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SERI_YOK,
            self::VALUE_SERI_VAR,
            self::VALUE_SERI_VAR_KONTROLSUZ,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
