<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://mimasweb.monitronics.net/CommonFunding?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://mimasweb.monitronics.net/CommonFunding?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \MoniFunding\ClassMap::get(),
);
/**
 * Samples for APIV ServiceType
 */
$aPIV = new \MoniFunding\ServiceType\APIV($options);
/**
 * Sample call for APIVersion operation/method
 */
if ($aPIV->APIVersion(new \MoniFunding\StructType\APIVersion()) !== false) {
    print_r($aPIV->getResult());
} else {
    print_r($aPIV->getLastError());
}
/**
 * Samples for Upsert ServiceType
 */
$upsert = new \MoniFunding\ServiceType\Upsert($options);
/**
 * Sample call for UpsertCommonFundingDataFromEcontract operation/method
 */
if ($upsert->UpsertCommonFundingDataFromEcontract(new \MoniFunding\StructType\UpsertCommonFundingDataFromEcontract()) !== false) {
    print_r($upsert->getResult());
} else {
    print_r($upsert->getLastError());
}
/**
 * Sample call for UpsertCommonFundingDataFromCustomerAdmin operation/method
 */
if ($upsert->UpsertCommonFundingDataFromCustomerAdmin(new \MoniFunding\StructType\UpsertCommonFundingDataFromCustomerAdmin()) !== false) {
    print_r($upsert->getResult());
} else {
    print_r($upsert->getLastError());
}
/**
 * Sample call for UpsertCommonFundingDataFromThirdPartyCRM operation/method
 */
if ($upsert->UpsertCommonFundingDataFromThirdPartyCRM(new \MoniFunding\StructType\UpsertCommonFundingDataFromThirdPartyCRM()) !== false) {
    print_r($upsert->getResult());
} else {
    print_r($upsert->getLastError());
}
