<?php

namespace MoniFunding;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'CommonFundingDataObject' => '\\MoniFunding\\StructType\\CommonFundingDataObject',
            'CommonFundingDataPrivateObject' => '\\MoniFunding\\StructType\\CommonFundingDataPrivateObject',
            'CommonFundingDataResults' => '\\MoniFunding\\StructType\\CommonFundingDataResults',
            'APIVersion' => '\\MoniFunding\\StructType\\APIVersion',
            'APIVersionResponse' => '\\MoniFunding\\StructType\\APIVersionResponse',
            'UpsertCommonFundingDataFromEcontract' => '\\MoniFunding\\StructType\\UpsertCommonFundingDataFromEcontract',
            'UpsertCommonFundingDataFromEcontractResponse' => '\\MoniFunding\\StructType\\UpsertCommonFundingDataFromEcontractResponse',
            'UpsertCommonFundingDataFromCustomerAdmin' => '\\MoniFunding\\StructType\\UpsertCommonFundingDataFromCustomerAdmin',
            'UpsertCommonFundingDataFromCustomerAdminResponse' => '\\MoniFunding\\StructType\\UpsertCommonFundingDataFromCustomerAdminResponse',
            'UpsertCommonFundingDataFromThirdPartyCRM' => '\\MoniFunding\\StructType\\UpsertCommonFundingDataFromThirdPartyCRM',
            'UpsertCommonFundingDataFromThirdPartyCRMResponse' => '\\MoniFunding\\StructType\\UpsertCommonFundingDataFromThirdPartyCRMResponse',
        );
    }
}
