<?php

namespace MoniFunding\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpsertCommonFundingDataFromThirdPartyCRM StructType
 * @subpackage Structs
 */
class UpsertCommonFundingDataFromThirdPartyCRM extends AbstractStructBase
{
    /**
     * The ApplicationID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ApplicationID;
    /**
     * The Username
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Username;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Password;
    /**
     * The CSNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CSNumber;
    /**
     * The ContractID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ContractID;
    /**
     * Constructor method for UpsertCommonFundingDataFromThirdPartyCRM
     * @uses UpsertCommonFundingDataFromThirdPartyCRM::setApplicationID()
     * @uses UpsertCommonFundingDataFromThirdPartyCRM::setUsername()
     * @uses UpsertCommonFundingDataFromThirdPartyCRM::setPassword()
     * @uses UpsertCommonFundingDataFromThirdPartyCRM::setCSNumber()
     * @uses UpsertCommonFundingDataFromThirdPartyCRM::setContractID()
     * @param int $applicationID
     * @param string $username
     * @param string $password
     * @param string $cSNumber
     * @param int $contractID
     */
    public function __construct($applicationID = null, $username = null, $password = null, $cSNumber = null, $contractID = null)
    {
        $this
            ->setApplicationID($applicationID)
            ->setUsername($username)
            ->setPassword($password)
            ->setCSNumber($cSNumber)
            ->setContractID($contractID);
    }
    /**
     * Get ApplicationID value
     * @return int|null
     */
    public function getApplicationID()
    {
        return $this->ApplicationID;
    }
    /**
     * Set ApplicationID value
     * @param int $applicationID
     * @return \MoniFunding\StructType\UpsertCommonFundingDataFromThirdPartyCRM
     */
    public function setApplicationID($applicationID = null)
    {
        // validation for constraint: int
        if (!is_null($applicationID) && !(is_int($applicationID) || ctype_digit($applicationID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($applicationID, true), gettype($applicationID)), __LINE__);
        }
        $this->ApplicationID = $applicationID;
        return $this;
    }
    /**
     * Get Username value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsername()
    {
        return isset($this->Username) ? $this->Username : null;
    }
    /**
     * Set Username value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $username
     * @return \MoniFunding\StructType\UpsertCommonFundingDataFromThirdPartyCRM
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        if (is_null($username) || (is_array($username) && empty($username))) {
            unset($this->Username);
        } else {
            $this->Username = $username;
        }
        return $this;
    }
    /**
     * Get Password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassword()
    {
        return isset($this->Password) ? $this->Password : null;
    }
    /**
     * Set Password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $password
     * @return \MoniFunding\StructType\UpsertCommonFundingDataFromThirdPartyCRM
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        if (is_null($password) || (is_array($password) && empty($password))) {
            unset($this->Password);
        } else {
            $this->Password = $password;
        }
        return $this;
    }
    /**
     * Get CSNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCSNumber()
    {
        return isset($this->CSNumber) ? $this->CSNumber : null;
    }
    /**
     * Set CSNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cSNumber
     * @return \MoniFunding\StructType\UpsertCommonFundingDataFromThirdPartyCRM
     */
    public function setCSNumber($cSNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cSNumber) && !is_string($cSNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cSNumber, true), gettype($cSNumber)), __LINE__);
        }
        if (is_null($cSNumber) || (is_array($cSNumber) && empty($cSNumber))) {
            unset($this->CSNumber);
        } else {
            $this->CSNumber = $cSNumber;
        }
        return $this;
    }
    /**
     * Get ContractID value
     * @return int|null
     */
    public function getContractID()
    {
        return $this->ContractID;
    }
    /**
     * Set ContractID value
     * @param int $contractID
     * @return \MoniFunding\StructType\UpsertCommonFundingDataFromThirdPartyCRM
     */
    public function setContractID($contractID = null)
    {
        // validation for constraint: int
        if (!is_null($contractID) && !(is_int($contractID) || ctype_digit($contractID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($contractID, true), gettype($contractID)), __LINE__);
        }
        $this->ContractID = $contractID;
        return $this;
    }
}
