<?php

namespace MoniFunding\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommonFundingDataPrivateObject StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CommonFundingDataPrivateObject
 * @subpackage Structs
 */
class CommonFundingDataPrivateObject extends AbstractStructBase
{
    /**
     * The CommonFundingDataPrivateID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CommonFundingDataPrivateID;
    /**
     * The ECInitialBankAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECInitialBankAccount;
    /**
     * The ECInitialCCExpireMonth
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ECInitialCCExpireMonth;
    /**
     * The ECInitialCCExpireYear
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ECInitialCCExpireYear;
    /**
     * The ECInitialCCNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECInitialCCNumber;
    /**
     * The ECInitialCanada
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ECInitialCanada;
    /**
     * The ECInitialRoutingNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECInitialRoutingNumber;
    /**
     * The ECPrimaryBirthDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECPrimaryBirthDate;
    /**
     * The ECPrimarySSN
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECPrimarySSN;
    /**
     * The ECRecurringBankAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECRecurringBankAccount;
    /**
     * The ECRecurringCCExpireMonth
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ECRecurringCCExpireMonth;
    /**
     * The ECRecurringCCExpireYear
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ECRecurringCCExpireYear;
    /**
     * The ECRecurringCCNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECRecurringCCNumber;
    /**
     * The ECRecurringCanada
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ECRecurringCanada;
    /**
     * The ECRecurringRoutingNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECRecurringRoutingNumber;
    /**
     * The ECSecondaryBirthDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECSecondaryBirthDate;
    /**
     * The ECSecondarySSN
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECSecondarySSN;
    /**
     * Constructor method for CommonFundingDataPrivateObject
     * @uses CommonFundingDataPrivateObject::setCommonFundingDataPrivateID()
     * @uses CommonFundingDataPrivateObject::setECInitialBankAccount()
     * @uses CommonFundingDataPrivateObject::setECInitialCCExpireMonth()
     * @uses CommonFundingDataPrivateObject::setECInitialCCExpireYear()
     * @uses CommonFundingDataPrivateObject::setECInitialCCNumber()
     * @uses CommonFundingDataPrivateObject::setECInitialCanada()
     * @uses CommonFundingDataPrivateObject::setECInitialRoutingNumber()
     * @uses CommonFundingDataPrivateObject::setECPrimaryBirthDate()
     * @uses CommonFundingDataPrivateObject::setECPrimarySSN()
     * @uses CommonFundingDataPrivateObject::setECRecurringBankAccount()
     * @uses CommonFundingDataPrivateObject::setECRecurringCCExpireMonth()
     * @uses CommonFundingDataPrivateObject::setECRecurringCCExpireYear()
     * @uses CommonFundingDataPrivateObject::setECRecurringCCNumber()
     * @uses CommonFundingDataPrivateObject::setECRecurringCanada()
     * @uses CommonFundingDataPrivateObject::setECRecurringRoutingNumber()
     * @uses CommonFundingDataPrivateObject::setECSecondaryBirthDate()
     * @uses CommonFundingDataPrivateObject::setECSecondarySSN()
     * @param int $commonFundingDataPrivateID
     * @param string $eCInitialBankAccount
     * @param int $eCInitialCCExpireMonth
     * @param int $eCInitialCCExpireYear
     * @param string $eCInitialCCNumber
     * @param bool $eCInitialCanada
     * @param string $eCInitialRoutingNumber
     * @param string $eCPrimaryBirthDate
     * @param string $eCPrimarySSN
     * @param string $eCRecurringBankAccount
     * @param int $eCRecurringCCExpireMonth
     * @param int $eCRecurringCCExpireYear
     * @param string $eCRecurringCCNumber
     * @param bool $eCRecurringCanada
     * @param string $eCRecurringRoutingNumber
     * @param string $eCSecondaryBirthDate
     * @param string $eCSecondarySSN
     */
    public function __construct($commonFundingDataPrivateID = null, $eCInitialBankAccount = null, $eCInitialCCExpireMonth = null, $eCInitialCCExpireYear = null, $eCInitialCCNumber = null, $eCInitialCanada = null, $eCInitialRoutingNumber = null, $eCPrimaryBirthDate = null, $eCPrimarySSN = null, $eCRecurringBankAccount = null, $eCRecurringCCExpireMonth = null, $eCRecurringCCExpireYear = null, $eCRecurringCCNumber = null, $eCRecurringCanada = null, $eCRecurringRoutingNumber = null, $eCSecondaryBirthDate = null, $eCSecondarySSN = null)
    {
        $this
            ->setCommonFundingDataPrivateID($commonFundingDataPrivateID)
            ->setECInitialBankAccount($eCInitialBankAccount)
            ->setECInitialCCExpireMonth($eCInitialCCExpireMonth)
            ->setECInitialCCExpireYear($eCInitialCCExpireYear)
            ->setECInitialCCNumber($eCInitialCCNumber)
            ->setECInitialCanada($eCInitialCanada)
            ->setECInitialRoutingNumber($eCInitialRoutingNumber)
            ->setECPrimaryBirthDate($eCPrimaryBirthDate)
            ->setECPrimarySSN($eCPrimarySSN)
            ->setECRecurringBankAccount($eCRecurringBankAccount)
            ->setECRecurringCCExpireMonth($eCRecurringCCExpireMonth)
            ->setECRecurringCCExpireYear($eCRecurringCCExpireYear)
            ->setECRecurringCCNumber($eCRecurringCCNumber)
            ->setECRecurringCanada($eCRecurringCanada)
            ->setECRecurringRoutingNumber($eCRecurringRoutingNumber)
            ->setECSecondaryBirthDate($eCSecondaryBirthDate)
            ->setECSecondarySSN($eCSecondarySSN);
    }
    /**
     * Get CommonFundingDataPrivateID value
     * @return int|null
     */
    public function getCommonFundingDataPrivateID()
    {
        return $this->CommonFundingDataPrivateID;
    }
    /**
     * Set CommonFundingDataPrivateID value
     * @param int $commonFundingDataPrivateID
     * @return \MoniFunding\StructType\CommonFundingDataPrivateObject
     */
    public function setCommonFundingDataPrivateID($commonFundingDataPrivateID = null)
    {
        // validation for constraint: int
        if (!is_null($commonFundingDataPrivateID) && !(is_int($commonFundingDataPrivateID) || ctype_digit($commonFundingDataPrivateID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($commonFundingDataPrivateID, true), gettype($commonFundingDataPrivateID)), __LINE__);
        }
        $this->CommonFundingDataPrivateID = $commonFundingDataPrivateID;
        return $this;
    }
    /**
     * Get ECInitialBankAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECInitialBankAccount()
    {
        return isset($this->ECInitialBankAccount) ? $this->ECInitialBankAccount : null;
    }
    /**
     * Set ECInitialBankAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCInitialBankAccount
     * @return \MoniFunding\StructType\CommonFundingDataPrivateObject
     */
    public function setECInitialBankAccount($eCInitialBankAccount = null)
    {
        // validation for constraint: string
        if (!is_null($eCInitialBankAccount) && !is_string($eCInitialBankAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCInitialBankAccount, true), gettype($eCInitialBankAccount)), __LINE__);
        }
        if (is_null($eCInitialBankAccount) || (is_array($eCInitialBankAccount) && empty($eCInitialBankAccount))) {
            unset($this->ECInitialBankAccount);
        } else {
            $this->ECInitialBankAccount = $eCInitialBankAccount;
        }
        return $this;
    }
    /**
     * Get ECInitialCCExpireMonth value
     * @return int|null
     */
    public function getECInitialCCExpireMonth()
    {
        return $this->ECInitialCCExpireMonth;
    }
    /**
     * Set ECInitialCCExpireMonth value
     * @param int $eCInitialCCExpireMonth
     * @return \MoniFunding\StructType\CommonFundingDataPrivateObject
     */
    public function setECInitialCCExpireMonth($eCInitialCCExpireMonth = null)
    {
        // validation for constraint: int
        if (!is_null($eCInitialCCExpireMonth) && !(is_int($eCInitialCCExpireMonth) || ctype_digit($eCInitialCCExpireMonth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eCInitialCCExpireMonth, true), gettype($eCInitialCCExpireMonth)), __LINE__);
        }
        $this->ECInitialCCExpireMonth = $eCInitialCCExpireMonth;
        return $this;
    }
    /**
     * Get ECInitialCCExpireYear value
     * @return int|null
     */
    public function getECInitialCCExpireYear()
    {
        return $this->ECInitialCCExpireYear;
    }
    /**
     * Set ECInitialCCExpireYear value
     * @param int $eCInitialCCExpireYear
     * @return \MoniFunding\StructType\CommonFundingDataPrivateObject
     */
    public function setECInitialCCExpireYear($eCInitialCCExpireYear = null)
    {
        // validation for constraint: int
        if (!is_null($eCInitialCCExpireYear) && !(is_int($eCInitialCCExpireYear) || ctype_digit($eCInitialCCExpireYear))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eCInitialCCExpireYear, true), gettype($eCInitialCCExpireYear)), __LINE__);
        }
        $this->ECInitialCCExpireYear = $eCInitialCCExpireYear;
        return $this;
    }
    /**
     * Get ECInitialCCNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECInitialCCNumber()
    {
        return isset($this->ECInitialCCNumber) ? $this->ECInitialCCNumber : null;
    }
    /**
     * Set ECInitialCCNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCInitialCCNumber
     * @return \MoniFunding\StructType\CommonFundingDataPrivateObject
     */
    public function setECInitialCCNumber($eCInitialCCNumber = null)
    {
        // validation for constraint: string
        if (!is_null($eCInitialCCNumber) && !is_string($eCInitialCCNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCInitialCCNumber, true), gettype($eCInitialCCNumber)), __LINE__);
        }
        if (is_null($eCInitialCCNumber) || (is_array($eCInitialCCNumber) && empty($eCInitialCCNumber))) {
            unset($this->ECInitialCCNumber);
        } else {
            $this->ECInitialCCNumber = $eCInitialCCNumber;
        }
        return $this;
    }
    /**
     * Get ECInitialCanada value
     * @return bool|null
     */
    public function getECInitialCanada()
    {
        return $this->ECInitialCanada;
    }
    /**
     * Set ECInitialCanada value
     * @param bool $eCInitialCanada
     * @return \MoniFunding\StructType\CommonFundingDataPrivateObject
     */
    public function setECInitialCanada($eCInitialCanada = null)
    {
        // validation for constraint: boolean
        if (!is_null($eCInitialCanada) && !is_bool($eCInitialCanada)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($eCInitialCanada, true), gettype($eCInitialCanada)), __LINE__);
        }
        $this->ECInitialCanada = $eCInitialCanada;
        return $this;
    }
    /**
     * Get ECInitialRoutingNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECInitialRoutingNumber()
    {
        return isset($this->ECInitialRoutingNumber) ? $this->ECInitialRoutingNumber : null;
    }
    /**
     * Set ECInitialRoutingNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCInitialRoutingNumber
     * @return \MoniFunding\StructType\CommonFundingDataPrivateObject
     */
    public function setECInitialRoutingNumber($eCInitialRoutingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($eCInitialRoutingNumber) && !is_string($eCInitialRoutingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCInitialRoutingNumber, true), gettype($eCInitialRoutingNumber)), __LINE__);
        }
        if (is_null($eCInitialRoutingNumber) || (is_array($eCInitialRoutingNumber) && empty($eCInitialRoutingNumber))) {
            unset($this->ECInitialRoutingNumber);
        } else {
            $this->ECInitialRoutingNumber = $eCInitialRoutingNumber;
        }
        return $this;
    }
    /**
     * Get ECPrimaryBirthDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECPrimaryBirthDate()
    {
        return isset($this->ECPrimaryBirthDate) ? $this->ECPrimaryBirthDate : null;
    }
    /**
     * Set ECPrimaryBirthDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCPrimaryBirthDate
     * @return \MoniFunding\StructType\CommonFundingDataPrivateObject
     */
    public function setECPrimaryBirthDate($eCPrimaryBirthDate = null)
    {
        // validation for constraint: string
        if (!is_null($eCPrimaryBirthDate) && !is_string($eCPrimaryBirthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCPrimaryBirthDate, true), gettype($eCPrimaryBirthDate)), __LINE__);
        }
        if (is_null($eCPrimaryBirthDate) || (is_array($eCPrimaryBirthDate) && empty($eCPrimaryBirthDate))) {
            unset($this->ECPrimaryBirthDate);
        } else {
            $this->ECPrimaryBirthDate = $eCPrimaryBirthDate;
        }
        return $this;
    }
    /**
     * Get ECPrimarySSN value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECPrimarySSN()
    {
        return isset($this->ECPrimarySSN) ? $this->ECPrimarySSN : null;
    }
    /**
     * Set ECPrimarySSN value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCPrimarySSN
     * @return \MoniFunding\StructType\CommonFundingDataPrivateObject
     */
    public function setECPrimarySSN($eCPrimarySSN = null)
    {
        // validation for constraint: string
        if (!is_null($eCPrimarySSN) && !is_string($eCPrimarySSN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCPrimarySSN, true), gettype($eCPrimarySSN)), __LINE__);
        }
        if (is_null($eCPrimarySSN) || (is_array($eCPrimarySSN) && empty($eCPrimarySSN))) {
            unset($this->ECPrimarySSN);
        } else {
            $this->ECPrimarySSN = $eCPrimarySSN;
        }
        return $this;
    }
    /**
     * Get ECRecurringBankAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECRecurringBankAccount()
    {
        return isset($this->ECRecurringBankAccount) ? $this->ECRecurringBankAccount : null;
    }
    /**
     * Set ECRecurringBankAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCRecurringBankAccount
     * @return \MoniFunding\StructType\CommonFundingDataPrivateObject
     */
    public function setECRecurringBankAccount($eCRecurringBankAccount = null)
    {
        // validation for constraint: string
        if (!is_null($eCRecurringBankAccount) && !is_string($eCRecurringBankAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCRecurringBankAccount, true), gettype($eCRecurringBankAccount)), __LINE__);
        }
        if (is_null($eCRecurringBankAccount) || (is_array($eCRecurringBankAccount) && empty($eCRecurringBankAccount))) {
            unset($this->ECRecurringBankAccount);
        } else {
            $this->ECRecurringBankAccount = $eCRecurringBankAccount;
        }
        return $this;
    }
    /**
     * Get ECRecurringCCExpireMonth value
     * @return int|null
     */
    public function getECRecurringCCExpireMonth()
    {
        return $this->ECRecurringCCExpireMonth;
    }
    /**
     * Set ECRecurringCCExpireMonth value
     * @param int $eCRecurringCCExpireMonth
     * @return \MoniFunding\StructType\CommonFundingDataPrivateObject
     */
    public function setECRecurringCCExpireMonth($eCRecurringCCExpireMonth = null)
    {
        // validation for constraint: int
        if (!is_null($eCRecurringCCExpireMonth) && !(is_int($eCRecurringCCExpireMonth) || ctype_digit($eCRecurringCCExpireMonth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eCRecurringCCExpireMonth, true), gettype($eCRecurringCCExpireMonth)), __LINE__);
        }
        $this->ECRecurringCCExpireMonth = $eCRecurringCCExpireMonth;
        return $this;
    }
    /**
     * Get ECRecurringCCExpireYear value
     * @return int|null
     */
    public function getECRecurringCCExpireYear()
    {
        return $this->ECRecurringCCExpireYear;
    }
    /**
     * Set ECRecurringCCExpireYear value
     * @param int $eCRecurringCCExpireYear
     * @return \MoniFunding\StructType\CommonFundingDataPrivateObject
     */
    public function setECRecurringCCExpireYear($eCRecurringCCExpireYear = null)
    {
        // validation for constraint: int
        if (!is_null($eCRecurringCCExpireYear) && !(is_int($eCRecurringCCExpireYear) || ctype_digit($eCRecurringCCExpireYear))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eCRecurringCCExpireYear, true), gettype($eCRecurringCCExpireYear)), __LINE__);
        }
        $this->ECRecurringCCExpireYear = $eCRecurringCCExpireYear;
        return $this;
    }
    /**
     * Get ECRecurringCCNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECRecurringCCNumber()
    {
        return isset($this->ECRecurringCCNumber) ? $this->ECRecurringCCNumber : null;
    }
    /**
     * Set ECRecurringCCNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCRecurringCCNumber
     * @return \MoniFunding\StructType\CommonFundingDataPrivateObject
     */
    public function setECRecurringCCNumber($eCRecurringCCNumber = null)
    {
        // validation for constraint: string
        if (!is_null($eCRecurringCCNumber) && !is_string($eCRecurringCCNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCRecurringCCNumber, true), gettype($eCRecurringCCNumber)), __LINE__);
        }
        if (is_null($eCRecurringCCNumber) || (is_array($eCRecurringCCNumber) && empty($eCRecurringCCNumber))) {
            unset($this->ECRecurringCCNumber);
        } else {
            $this->ECRecurringCCNumber = $eCRecurringCCNumber;
        }
        return $this;
    }
    /**
     * Get ECRecurringCanada value
     * @return bool|null
     */
    public function getECRecurringCanada()
    {
        return $this->ECRecurringCanada;
    }
    /**
     * Set ECRecurringCanada value
     * @param bool $eCRecurringCanada
     * @return \MoniFunding\StructType\CommonFundingDataPrivateObject
     */
    public function setECRecurringCanada($eCRecurringCanada = null)
    {
        // validation for constraint: boolean
        if (!is_null($eCRecurringCanada) && !is_bool($eCRecurringCanada)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($eCRecurringCanada, true), gettype($eCRecurringCanada)), __LINE__);
        }
        $this->ECRecurringCanada = $eCRecurringCanada;
        return $this;
    }
    /**
     * Get ECRecurringRoutingNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECRecurringRoutingNumber()
    {
        return isset($this->ECRecurringRoutingNumber) ? $this->ECRecurringRoutingNumber : null;
    }
    /**
     * Set ECRecurringRoutingNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCRecurringRoutingNumber
     * @return \MoniFunding\StructType\CommonFundingDataPrivateObject
     */
    public function setECRecurringRoutingNumber($eCRecurringRoutingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($eCRecurringRoutingNumber) && !is_string($eCRecurringRoutingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCRecurringRoutingNumber, true), gettype($eCRecurringRoutingNumber)), __LINE__);
        }
        if (is_null($eCRecurringRoutingNumber) || (is_array($eCRecurringRoutingNumber) && empty($eCRecurringRoutingNumber))) {
            unset($this->ECRecurringRoutingNumber);
        } else {
            $this->ECRecurringRoutingNumber = $eCRecurringRoutingNumber;
        }
        return $this;
    }
    /**
     * Get ECSecondaryBirthDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECSecondaryBirthDate()
    {
        return isset($this->ECSecondaryBirthDate) ? $this->ECSecondaryBirthDate : null;
    }
    /**
     * Set ECSecondaryBirthDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCSecondaryBirthDate
     * @return \MoniFunding\StructType\CommonFundingDataPrivateObject
     */
    public function setECSecondaryBirthDate($eCSecondaryBirthDate = null)
    {
        // validation for constraint: string
        if (!is_null($eCSecondaryBirthDate) && !is_string($eCSecondaryBirthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCSecondaryBirthDate, true), gettype($eCSecondaryBirthDate)), __LINE__);
        }
        if (is_null($eCSecondaryBirthDate) || (is_array($eCSecondaryBirthDate) && empty($eCSecondaryBirthDate))) {
            unset($this->ECSecondaryBirthDate);
        } else {
            $this->ECSecondaryBirthDate = $eCSecondaryBirthDate;
        }
        return $this;
    }
    /**
     * Get ECSecondarySSN value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECSecondarySSN()
    {
        return isset($this->ECSecondarySSN) ? $this->ECSecondarySSN : null;
    }
    /**
     * Set ECSecondarySSN value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCSecondarySSN
     * @return \MoniFunding\StructType\CommonFundingDataPrivateObject
     */
    public function setECSecondarySSN($eCSecondarySSN = null)
    {
        // validation for constraint: string
        if (!is_null($eCSecondarySSN) && !is_string($eCSecondarySSN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCSecondarySSN, true), gettype($eCSecondarySSN)), __LINE__);
        }
        if (is_null($eCSecondarySSN) || (is_array($eCSecondarySSN) && empty($eCSecondarySSN))) {
            unset($this->ECSecondarySSN);
        } else {
            $this->ECSecondarySSN = $eCSecondarySSN;
        }
        return $this;
    }
}
