<?php

namespace MoniFunding\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommonFundingDataObject StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CommonFundingDataObject
 * @subpackage Structs
 */
class CommonFundingDataObject extends AbstractStructBase
{
    /**
     * The CSNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CSNumber;
    /**
     * The ClosingDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ClosingDate;
    /**
     * The CommonFundingDataID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CommonFundingDataID;
    /**
     * The ContractID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ContractID;
    /**
     * The DealerNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DealerNumber;
    /**
     * The ECActivationFee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ECActivationFee;
    /**
     * The ECBillStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECBillStartDate;
    /**
     * The ECBillingAddress1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECBillingAddress1;
    /**
     * The ECBillingAddress2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECBillingAddress2;
    /**
     * The ECBillingCity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECBillingCity;
    /**
     * The ECBillingState
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECBillingState;
    /**
     * The ECBillingZip
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECBillingZip;
    /**
     * The ECBusinessName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECBusinessName;
    /**
     * The ECBusinessType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECBusinessType;
    /**
     * The ECContractDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECContractDate;
    /**
     * The ECCustomerType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECCustomerType;
    /**
     * The ECDraftDay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ECDraftDay;
    /**
     * The ECEnvelopeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECEnvelopeID;
    /**
     * The ECEquipmentSubtotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ECEquipmentSubtotal;
    /**
     * The ECEquipmentTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ECEquipmentTotal;
    /**
     * The ECFinancePartner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECFinancePartner;
    /**
     * The ECFinancePaymentCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ECFinancePaymentCount;
    /**
     * The ECGuardAddendum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ECGuardAddendum;
    /**
     * The ECHomeOwner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ECHomeOwner;
    /**
     * The ECInstallationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECInstallationDate;
    /**
     * The ECIsFinanced
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ECIsFinanced;
    /**
     * The ECMonthPaidUpFront
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ECMonthPaidUpFront;
    /**
     * The ECNOCDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECNOCDate;
    /**
     * The ECNewConstruction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ECNewConstruction;
    /**
     * The ECOtherAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ECOtherAmount;
    /**
     * The ECPartnerProgramDiscountAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ECPartnerProgramDiscountAmount;
    /**
     * The ECPartnerProgramID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ECPartnerProgramID;
    /**
     * The ECPartnerProgramMemberID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECPartnerProgramMemberID;
    /**
     * The ECPaymentCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ECPaymentCount;
    /**
     * The ECPaymentExtendedServiceOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ECPaymentExtendedServiceOption;
    /**
     * The ECPaymentMonthlyEquipmentAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ECPaymentMonthlyEquipmentAmount;
    /**
     * The ECPaymentMonthlyEquipmentSplitRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECPaymentMonthlyEquipmentSplitRate;
    /**
     * The ECPermitAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ECPermitAmount;
    /**
     * The ECPrimaryEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECPrimaryEmail;
    /**
     * The ECPrimaryFirstName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECPrimaryFirstName;
    /**
     * The ECPrimaryLastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECPrimaryLastName;
    /**
     * The ECPrimaryPhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECPrimaryPhone;
    /**
     * The ECPromotionPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ECPromotionPeriod;
    /**
     * The ECRMR
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ECRMR;
    /**
     * The ECSalesperson
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECSalesperson;
    /**
     * The ECSecondaryEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECSecondaryEmail;
    /**
     * The ECSecondaryFirstName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECSecondaryFirstName;
    /**
     * The ECSecondaryLastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECSecondaryLastName;
    /**
     * The ECSecondaryPhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECSecondaryPhone;
    /**
     * The ECSiteAddress1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECSiteAddress1;
    /**
     * The ECSiteAddress2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECSiteAddress2;
    /**
     * The ECSiteCity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECSiteCity;
    /**
     * The ECSiteState
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECSiteState;
    /**
     * The ECSiteZip
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECSiteZip;
    /**
     * The ECTagAutoPay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ECTagAutoPay;
    /**
     * The ECTagCommercialDoc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ECTagCommercialDoc;
    /**
     * The ECTagHomeownerDoc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ECTagHomeownerDoc;
    /**
     * The ECTagProofOfPay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ECTagProofOfPay;
    /**
     * The ECTagStoreFront
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ECTagStoreFront;
    /**
     * The ECTaxAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ECTaxAmount;
    /**
     * The ECVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ECVersion;
    /**
     * The ExtendedServicePlanMonthlyAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ExtendedServicePlanMonthlyAmount;
    /**
     * The HasExtendedServicePlan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasExtendedServicePlan;
    /**
     * The PrivateData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \MoniFunding\StructType\CommonFundingDataPrivateObject
     */
    public $PrivateData;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StatusCode;
    /**
     * Constructor method for CommonFundingDataObject
     * @uses CommonFundingDataObject::setCSNumber()
     * @uses CommonFundingDataObject::setClosingDate()
     * @uses CommonFundingDataObject::setCommonFundingDataID()
     * @uses CommonFundingDataObject::setContractID()
     * @uses CommonFundingDataObject::setDealerNumber()
     * @uses CommonFundingDataObject::setECActivationFee()
     * @uses CommonFundingDataObject::setECBillStartDate()
     * @uses CommonFundingDataObject::setECBillingAddress1()
     * @uses CommonFundingDataObject::setECBillingAddress2()
     * @uses CommonFundingDataObject::setECBillingCity()
     * @uses CommonFundingDataObject::setECBillingState()
     * @uses CommonFundingDataObject::setECBillingZip()
     * @uses CommonFundingDataObject::setECBusinessName()
     * @uses CommonFundingDataObject::setECBusinessType()
     * @uses CommonFundingDataObject::setECContractDate()
     * @uses CommonFundingDataObject::setECCustomerType()
     * @uses CommonFundingDataObject::setECDraftDay()
     * @uses CommonFundingDataObject::setECEnvelopeID()
     * @uses CommonFundingDataObject::setECEquipmentSubtotal()
     * @uses CommonFundingDataObject::setECEquipmentTotal()
     * @uses CommonFundingDataObject::setECFinancePartner()
     * @uses CommonFundingDataObject::setECFinancePaymentCount()
     * @uses CommonFundingDataObject::setECGuardAddendum()
     * @uses CommonFundingDataObject::setECHomeOwner()
     * @uses CommonFundingDataObject::setECInstallationDate()
     * @uses CommonFundingDataObject::setECIsFinanced()
     * @uses CommonFundingDataObject::setECMonthPaidUpFront()
     * @uses CommonFundingDataObject::setECNOCDate()
     * @uses CommonFundingDataObject::setECNewConstruction()
     * @uses CommonFundingDataObject::setECOtherAmount()
     * @uses CommonFundingDataObject::setECPartnerProgramDiscountAmount()
     * @uses CommonFundingDataObject::setECPartnerProgramID()
     * @uses CommonFundingDataObject::setECPartnerProgramMemberID()
     * @uses CommonFundingDataObject::setECPaymentCount()
     * @uses CommonFundingDataObject::setECPaymentExtendedServiceOption()
     * @uses CommonFundingDataObject::setECPaymentMonthlyEquipmentAmount()
     * @uses CommonFundingDataObject::setECPaymentMonthlyEquipmentSplitRate()
     * @uses CommonFundingDataObject::setECPermitAmount()
     * @uses CommonFundingDataObject::setECPrimaryEmail()
     * @uses CommonFundingDataObject::setECPrimaryFirstName()
     * @uses CommonFundingDataObject::setECPrimaryLastName()
     * @uses CommonFundingDataObject::setECPrimaryPhone()
     * @uses CommonFundingDataObject::setECPromotionPeriod()
     * @uses CommonFundingDataObject::setECRMR()
     * @uses CommonFundingDataObject::setECSalesperson()
     * @uses CommonFundingDataObject::setECSecondaryEmail()
     * @uses CommonFundingDataObject::setECSecondaryFirstName()
     * @uses CommonFundingDataObject::setECSecondaryLastName()
     * @uses CommonFundingDataObject::setECSecondaryPhone()
     * @uses CommonFundingDataObject::setECSiteAddress1()
     * @uses CommonFundingDataObject::setECSiteAddress2()
     * @uses CommonFundingDataObject::setECSiteCity()
     * @uses CommonFundingDataObject::setECSiteState()
     * @uses CommonFundingDataObject::setECSiteZip()
     * @uses CommonFundingDataObject::setECTagAutoPay()
     * @uses CommonFundingDataObject::setECTagCommercialDoc()
     * @uses CommonFundingDataObject::setECTagHomeownerDoc()
     * @uses CommonFundingDataObject::setECTagProofOfPay()
     * @uses CommonFundingDataObject::setECTagStoreFront()
     * @uses CommonFundingDataObject::setECTaxAmount()
     * @uses CommonFundingDataObject::setECVersion()
     * @uses CommonFundingDataObject::setExtendedServicePlanMonthlyAmount()
     * @uses CommonFundingDataObject::setHasExtendedServicePlan()
     * @uses CommonFundingDataObject::setPrivateData()
     * @uses CommonFundingDataObject::setStatusCode()
     * @param string $cSNumber
     * @param string $closingDate
     * @param int $commonFundingDataID
     * @param int $contractID
     * @param string $dealerNumber
     * @param float $eCActivationFee
     * @param string $eCBillStartDate
     * @param string $eCBillingAddress1
     * @param string $eCBillingAddress2
     * @param string $eCBillingCity
     * @param string $eCBillingState
     * @param string $eCBillingZip
     * @param string $eCBusinessName
     * @param string $eCBusinessType
     * @param string $eCContractDate
     * @param string $eCCustomerType
     * @param int $eCDraftDay
     * @param string $eCEnvelopeID
     * @param float $eCEquipmentSubtotal
     * @param float $eCEquipmentTotal
     * @param string $eCFinancePartner
     * @param int $eCFinancePaymentCount
     * @param bool $eCGuardAddendum
     * @param bool $eCHomeOwner
     * @param string $eCInstallationDate
     * @param bool $eCIsFinanced
     * @param int $eCMonthPaidUpFront
     * @param string $eCNOCDate
     * @param bool $eCNewConstruction
     * @param float $eCOtherAmount
     * @param float $eCPartnerProgramDiscountAmount
     * @param int $eCPartnerProgramID
     * @param string $eCPartnerProgramMemberID
     * @param int $eCPaymentCount
     * @param bool $eCPaymentExtendedServiceOption
     * @param float $eCPaymentMonthlyEquipmentAmount
     * @param string $eCPaymentMonthlyEquipmentSplitRate
     * @param float $eCPermitAmount
     * @param string $eCPrimaryEmail
     * @param string $eCPrimaryFirstName
     * @param string $eCPrimaryLastName
     * @param string $eCPrimaryPhone
     * @param int $eCPromotionPeriod
     * @param float $eCRMR
     * @param string $eCSalesperson
     * @param string $eCSecondaryEmail
     * @param string $eCSecondaryFirstName
     * @param string $eCSecondaryLastName
     * @param string $eCSecondaryPhone
     * @param string $eCSiteAddress1
     * @param string $eCSiteAddress2
     * @param string $eCSiteCity
     * @param string $eCSiteState
     * @param string $eCSiteZip
     * @param bool $eCTagAutoPay
     * @param bool $eCTagCommercialDoc
     * @param bool $eCTagHomeownerDoc
     * @param bool $eCTagProofOfPay
     * @param bool $eCTagStoreFront
     * @param float $eCTaxAmount
     * @param string $eCVersion
     * @param float $extendedServicePlanMonthlyAmount
     * @param bool $hasExtendedServicePlan
     * @param \MoniFunding\StructType\CommonFundingDataPrivateObject $privateData
     * @param string $statusCode
     */
    public function __construct($cSNumber = null, $closingDate = null, $commonFundingDataID = null, $contractID = null, $dealerNumber = null, $eCActivationFee = null, $eCBillStartDate = null, $eCBillingAddress1 = null, $eCBillingAddress2 = null, $eCBillingCity = null, $eCBillingState = null, $eCBillingZip = null, $eCBusinessName = null, $eCBusinessType = null, $eCContractDate = null, $eCCustomerType = null, $eCDraftDay = null, $eCEnvelopeID = null, $eCEquipmentSubtotal = null, $eCEquipmentTotal = null, $eCFinancePartner = null, $eCFinancePaymentCount = null, $eCGuardAddendum = null, $eCHomeOwner = null, $eCInstallationDate = null, $eCIsFinanced = null, $eCMonthPaidUpFront = null, $eCNOCDate = null, $eCNewConstruction = null, $eCOtherAmount = null, $eCPartnerProgramDiscountAmount = null, $eCPartnerProgramID = null, $eCPartnerProgramMemberID = null, $eCPaymentCount = null, $eCPaymentExtendedServiceOption = null, $eCPaymentMonthlyEquipmentAmount = null, $eCPaymentMonthlyEquipmentSplitRate = null, $eCPermitAmount = null, $eCPrimaryEmail = null, $eCPrimaryFirstName = null, $eCPrimaryLastName = null, $eCPrimaryPhone = null, $eCPromotionPeriod = null, $eCRMR = null, $eCSalesperson = null, $eCSecondaryEmail = null, $eCSecondaryFirstName = null, $eCSecondaryLastName = null, $eCSecondaryPhone = null, $eCSiteAddress1 = null, $eCSiteAddress2 = null, $eCSiteCity = null, $eCSiteState = null, $eCSiteZip = null, $eCTagAutoPay = null, $eCTagCommercialDoc = null, $eCTagHomeownerDoc = null, $eCTagProofOfPay = null, $eCTagStoreFront = null, $eCTaxAmount = null, $eCVersion = null, $extendedServicePlanMonthlyAmount = null, $hasExtendedServicePlan = null, \MoniFunding\StructType\CommonFundingDataPrivateObject $privateData = null, $statusCode = null)
    {
        $this
            ->setCSNumber($cSNumber)
            ->setClosingDate($closingDate)
            ->setCommonFundingDataID($commonFundingDataID)
            ->setContractID($contractID)
            ->setDealerNumber($dealerNumber)
            ->setECActivationFee($eCActivationFee)
            ->setECBillStartDate($eCBillStartDate)
            ->setECBillingAddress1($eCBillingAddress1)
            ->setECBillingAddress2($eCBillingAddress2)
            ->setECBillingCity($eCBillingCity)
            ->setECBillingState($eCBillingState)
            ->setECBillingZip($eCBillingZip)
            ->setECBusinessName($eCBusinessName)
            ->setECBusinessType($eCBusinessType)
            ->setECContractDate($eCContractDate)
            ->setECCustomerType($eCCustomerType)
            ->setECDraftDay($eCDraftDay)
            ->setECEnvelopeID($eCEnvelopeID)
            ->setECEquipmentSubtotal($eCEquipmentSubtotal)
            ->setECEquipmentTotal($eCEquipmentTotal)
            ->setECFinancePartner($eCFinancePartner)
            ->setECFinancePaymentCount($eCFinancePaymentCount)
            ->setECGuardAddendum($eCGuardAddendum)
            ->setECHomeOwner($eCHomeOwner)
            ->setECInstallationDate($eCInstallationDate)
            ->setECIsFinanced($eCIsFinanced)
            ->setECMonthPaidUpFront($eCMonthPaidUpFront)
            ->setECNOCDate($eCNOCDate)
            ->setECNewConstruction($eCNewConstruction)
            ->setECOtherAmount($eCOtherAmount)
            ->setECPartnerProgramDiscountAmount($eCPartnerProgramDiscountAmount)
            ->setECPartnerProgramID($eCPartnerProgramID)
            ->setECPartnerProgramMemberID($eCPartnerProgramMemberID)
            ->setECPaymentCount($eCPaymentCount)
            ->setECPaymentExtendedServiceOption($eCPaymentExtendedServiceOption)
            ->setECPaymentMonthlyEquipmentAmount($eCPaymentMonthlyEquipmentAmount)
            ->setECPaymentMonthlyEquipmentSplitRate($eCPaymentMonthlyEquipmentSplitRate)
            ->setECPermitAmount($eCPermitAmount)
            ->setECPrimaryEmail($eCPrimaryEmail)
            ->setECPrimaryFirstName($eCPrimaryFirstName)
            ->setECPrimaryLastName($eCPrimaryLastName)
            ->setECPrimaryPhone($eCPrimaryPhone)
            ->setECPromotionPeriod($eCPromotionPeriod)
            ->setECRMR($eCRMR)
            ->setECSalesperson($eCSalesperson)
            ->setECSecondaryEmail($eCSecondaryEmail)
            ->setECSecondaryFirstName($eCSecondaryFirstName)
            ->setECSecondaryLastName($eCSecondaryLastName)
            ->setECSecondaryPhone($eCSecondaryPhone)
            ->setECSiteAddress1($eCSiteAddress1)
            ->setECSiteAddress2($eCSiteAddress2)
            ->setECSiteCity($eCSiteCity)
            ->setECSiteState($eCSiteState)
            ->setECSiteZip($eCSiteZip)
            ->setECTagAutoPay($eCTagAutoPay)
            ->setECTagCommercialDoc($eCTagCommercialDoc)
            ->setECTagHomeownerDoc($eCTagHomeownerDoc)
            ->setECTagProofOfPay($eCTagProofOfPay)
            ->setECTagStoreFront($eCTagStoreFront)
            ->setECTaxAmount($eCTaxAmount)
            ->setECVersion($eCVersion)
            ->setExtendedServicePlanMonthlyAmount($extendedServicePlanMonthlyAmount)
            ->setHasExtendedServicePlan($hasExtendedServicePlan)
            ->setPrivateData($privateData)
            ->setStatusCode($statusCode);
    }
    /**
     * Get CSNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCSNumber()
    {
        return isset($this->CSNumber) ? $this->CSNumber : null;
    }
    /**
     * Set CSNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cSNumber
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setCSNumber($cSNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cSNumber) && !is_string($cSNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cSNumber, true), gettype($cSNumber)), __LINE__);
        }
        if (is_null($cSNumber) || (is_array($cSNumber) && empty($cSNumber))) {
            unset($this->CSNumber);
        } else {
            $this->CSNumber = $cSNumber;
        }
        return $this;
    }
    /**
     * Get ClosingDate value
     * @return string|null
     */
    public function getClosingDate()
    {
        return $this->ClosingDate;
    }
    /**
     * Set ClosingDate value
     * @param string $closingDate
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setClosingDate($closingDate = null)
    {
        // validation for constraint: string
        if (!is_null($closingDate) && !is_string($closingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($closingDate, true), gettype($closingDate)), __LINE__);
        }
        $this->ClosingDate = $closingDate;
        return $this;
    }
    /**
     * Get CommonFundingDataID value
     * @return int|null
     */
    public function getCommonFundingDataID()
    {
        return $this->CommonFundingDataID;
    }
    /**
     * Set CommonFundingDataID value
     * @param int $commonFundingDataID
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setCommonFundingDataID($commonFundingDataID = null)
    {
        // validation for constraint: int
        if (!is_null($commonFundingDataID) && !(is_int($commonFundingDataID) || ctype_digit($commonFundingDataID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($commonFundingDataID, true), gettype($commonFundingDataID)), __LINE__);
        }
        $this->CommonFundingDataID = $commonFundingDataID;
        return $this;
    }
    /**
     * Get ContractID value
     * @return int|null
     */
    public function getContractID()
    {
        return $this->ContractID;
    }
    /**
     * Set ContractID value
     * @param int $contractID
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setContractID($contractID = null)
    {
        // validation for constraint: int
        if (!is_null($contractID) && !(is_int($contractID) || ctype_digit($contractID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($contractID, true), gettype($contractID)), __LINE__);
        }
        $this->ContractID = $contractID;
        return $this;
    }
    /**
     * Get DealerNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDealerNumber()
    {
        return isset($this->DealerNumber) ? $this->DealerNumber : null;
    }
    /**
     * Set DealerNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dealerNumber
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setDealerNumber($dealerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($dealerNumber) && !is_string($dealerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dealerNumber, true), gettype($dealerNumber)), __LINE__);
        }
        if (is_null($dealerNumber) || (is_array($dealerNumber) && empty($dealerNumber))) {
            unset($this->DealerNumber);
        } else {
            $this->DealerNumber = $dealerNumber;
        }
        return $this;
    }
    /**
     * Get ECActivationFee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getECActivationFee()
    {
        return isset($this->ECActivationFee) ? $this->ECActivationFee : null;
    }
    /**
     * Set ECActivationFee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $eCActivationFee
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECActivationFee($eCActivationFee = null)
    {
        // validation for constraint: float
        if (!is_null($eCActivationFee) && !(is_float($eCActivationFee) || is_numeric($eCActivationFee))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($eCActivationFee, true), gettype($eCActivationFee)), __LINE__);
        }
        if (is_null($eCActivationFee) || (is_array($eCActivationFee) && empty($eCActivationFee))) {
            unset($this->ECActivationFee);
        } else {
            $this->ECActivationFee = $eCActivationFee;
        }
        return $this;
    }
    /**
     * Get ECBillStartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECBillStartDate()
    {
        return isset($this->ECBillStartDate) ? $this->ECBillStartDate : null;
    }
    /**
     * Set ECBillStartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCBillStartDate
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECBillStartDate($eCBillStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($eCBillStartDate) && !is_string($eCBillStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCBillStartDate, true), gettype($eCBillStartDate)), __LINE__);
        }
        if (is_null($eCBillStartDate) || (is_array($eCBillStartDate) && empty($eCBillStartDate))) {
            unset($this->ECBillStartDate);
        } else {
            $this->ECBillStartDate = $eCBillStartDate;
        }
        return $this;
    }
    /**
     * Get ECBillingAddress1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECBillingAddress1()
    {
        return isset($this->ECBillingAddress1) ? $this->ECBillingAddress1 : null;
    }
    /**
     * Set ECBillingAddress1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCBillingAddress1
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECBillingAddress1($eCBillingAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($eCBillingAddress1) && !is_string($eCBillingAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCBillingAddress1, true), gettype($eCBillingAddress1)), __LINE__);
        }
        if (is_null($eCBillingAddress1) || (is_array($eCBillingAddress1) && empty($eCBillingAddress1))) {
            unset($this->ECBillingAddress1);
        } else {
            $this->ECBillingAddress1 = $eCBillingAddress1;
        }
        return $this;
    }
    /**
     * Get ECBillingAddress2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECBillingAddress2()
    {
        return isset($this->ECBillingAddress2) ? $this->ECBillingAddress2 : null;
    }
    /**
     * Set ECBillingAddress2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCBillingAddress2
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECBillingAddress2($eCBillingAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($eCBillingAddress2) && !is_string($eCBillingAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCBillingAddress2, true), gettype($eCBillingAddress2)), __LINE__);
        }
        if (is_null($eCBillingAddress2) || (is_array($eCBillingAddress2) && empty($eCBillingAddress2))) {
            unset($this->ECBillingAddress2);
        } else {
            $this->ECBillingAddress2 = $eCBillingAddress2;
        }
        return $this;
    }
    /**
     * Get ECBillingCity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECBillingCity()
    {
        return isset($this->ECBillingCity) ? $this->ECBillingCity : null;
    }
    /**
     * Set ECBillingCity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCBillingCity
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECBillingCity($eCBillingCity = null)
    {
        // validation for constraint: string
        if (!is_null($eCBillingCity) && !is_string($eCBillingCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCBillingCity, true), gettype($eCBillingCity)), __LINE__);
        }
        if (is_null($eCBillingCity) || (is_array($eCBillingCity) && empty($eCBillingCity))) {
            unset($this->ECBillingCity);
        } else {
            $this->ECBillingCity = $eCBillingCity;
        }
        return $this;
    }
    /**
     * Get ECBillingState value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECBillingState()
    {
        return isset($this->ECBillingState) ? $this->ECBillingState : null;
    }
    /**
     * Set ECBillingState value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCBillingState
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECBillingState($eCBillingState = null)
    {
        // validation for constraint: string
        if (!is_null($eCBillingState) && !is_string($eCBillingState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCBillingState, true), gettype($eCBillingState)), __LINE__);
        }
        if (is_null($eCBillingState) || (is_array($eCBillingState) && empty($eCBillingState))) {
            unset($this->ECBillingState);
        } else {
            $this->ECBillingState = $eCBillingState;
        }
        return $this;
    }
    /**
     * Get ECBillingZip value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECBillingZip()
    {
        return isset($this->ECBillingZip) ? $this->ECBillingZip : null;
    }
    /**
     * Set ECBillingZip value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCBillingZip
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECBillingZip($eCBillingZip = null)
    {
        // validation for constraint: string
        if (!is_null($eCBillingZip) && !is_string($eCBillingZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCBillingZip, true), gettype($eCBillingZip)), __LINE__);
        }
        if (is_null($eCBillingZip) || (is_array($eCBillingZip) && empty($eCBillingZip))) {
            unset($this->ECBillingZip);
        } else {
            $this->ECBillingZip = $eCBillingZip;
        }
        return $this;
    }
    /**
     * Get ECBusinessName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECBusinessName()
    {
        return isset($this->ECBusinessName) ? $this->ECBusinessName : null;
    }
    /**
     * Set ECBusinessName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCBusinessName
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECBusinessName($eCBusinessName = null)
    {
        // validation for constraint: string
        if (!is_null($eCBusinessName) && !is_string($eCBusinessName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCBusinessName, true), gettype($eCBusinessName)), __LINE__);
        }
        if (is_null($eCBusinessName) || (is_array($eCBusinessName) && empty($eCBusinessName))) {
            unset($this->ECBusinessName);
        } else {
            $this->ECBusinessName = $eCBusinessName;
        }
        return $this;
    }
    /**
     * Get ECBusinessType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECBusinessType()
    {
        return isset($this->ECBusinessType) ? $this->ECBusinessType : null;
    }
    /**
     * Set ECBusinessType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCBusinessType
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECBusinessType($eCBusinessType = null)
    {
        // validation for constraint: string
        if (!is_null($eCBusinessType) && !is_string($eCBusinessType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCBusinessType, true), gettype($eCBusinessType)), __LINE__);
        }
        if (is_null($eCBusinessType) || (is_array($eCBusinessType) && empty($eCBusinessType))) {
            unset($this->ECBusinessType);
        } else {
            $this->ECBusinessType = $eCBusinessType;
        }
        return $this;
    }
    /**
     * Get ECContractDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECContractDate()
    {
        return isset($this->ECContractDate) ? $this->ECContractDate : null;
    }
    /**
     * Set ECContractDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCContractDate
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECContractDate($eCContractDate = null)
    {
        // validation for constraint: string
        if (!is_null($eCContractDate) && !is_string($eCContractDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCContractDate, true), gettype($eCContractDate)), __LINE__);
        }
        if (is_null($eCContractDate) || (is_array($eCContractDate) && empty($eCContractDate))) {
            unset($this->ECContractDate);
        } else {
            $this->ECContractDate = $eCContractDate;
        }
        return $this;
    }
    /**
     * Get ECCustomerType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECCustomerType()
    {
        return isset($this->ECCustomerType) ? $this->ECCustomerType : null;
    }
    /**
     * Set ECCustomerType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCCustomerType
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECCustomerType($eCCustomerType = null)
    {
        // validation for constraint: string
        if (!is_null($eCCustomerType) && !is_string($eCCustomerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCCustomerType, true), gettype($eCCustomerType)), __LINE__);
        }
        if (is_null($eCCustomerType) || (is_array($eCCustomerType) && empty($eCCustomerType))) {
            unset($this->ECCustomerType);
        } else {
            $this->ECCustomerType = $eCCustomerType;
        }
        return $this;
    }
    /**
     * Get ECDraftDay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getECDraftDay()
    {
        return isset($this->ECDraftDay) ? $this->ECDraftDay : null;
    }
    /**
     * Set ECDraftDay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $eCDraftDay
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECDraftDay($eCDraftDay = null)
    {
        // validation for constraint: int
        if (!is_null($eCDraftDay) && !(is_int($eCDraftDay) || ctype_digit($eCDraftDay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eCDraftDay, true), gettype($eCDraftDay)), __LINE__);
        }
        if (is_null($eCDraftDay) || (is_array($eCDraftDay) && empty($eCDraftDay))) {
            unset($this->ECDraftDay);
        } else {
            $this->ECDraftDay = $eCDraftDay;
        }
        return $this;
    }
    /**
     * Get ECEnvelopeID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECEnvelopeID()
    {
        return isset($this->ECEnvelopeID) ? $this->ECEnvelopeID : null;
    }
    /**
     * Set ECEnvelopeID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCEnvelopeID
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECEnvelopeID($eCEnvelopeID = null)
    {
        // validation for constraint: string
        if (!is_null($eCEnvelopeID) && !is_string($eCEnvelopeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCEnvelopeID, true), gettype($eCEnvelopeID)), __LINE__);
        }
        if (is_null($eCEnvelopeID) || (is_array($eCEnvelopeID) && empty($eCEnvelopeID))) {
            unset($this->ECEnvelopeID);
        } else {
            $this->ECEnvelopeID = $eCEnvelopeID;
        }
        return $this;
    }
    /**
     * Get ECEquipmentSubtotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getECEquipmentSubtotal()
    {
        return isset($this->ECEquipmentSubtotal) ? $this->ECEquipmentSubtotal : null;
    }
    /**
     * Set ECEquipmentSubtotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $eCEquipmentSubtotal
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECEquipmentSubtotal($eCEquipmentSubtotal = null)
    {
        // validation for constraint: float
        if (!is_null($eCEquipmentSubtotal) && !(is_float($eCEquipmentSubtotal) || is_numeric($eCEquipmentSubtotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($eCEquipmentSubtotal, true), gettype($eCEquipmentSubtotal)), __LINE__);
        }
        if (is_null($eCEquipmentSubtotal) || (is_array($eCEquipmentSubtotal) && empty($eCEquipmentSubtotal))) {
            unset($this->ECEquipmentSubtotal);
        } else {
            $this->ECEquipmentSubtotal = $eCEquipmentSubtotal;
        }
        return $this;
    }
    /**
     * Get ECEquipmentTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getECEquipmentTotal()
    {
        return isset($this->ECEquipmentTotal) ? $this->ECEquipmentTotal : null;
    }
    /**
     * Set ECEquipmentTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $eCEquipmentTotal
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECEquipmentTotal($eCEquipmentTotal = null)
    {
        // validation for constraint: float
        if (!is_null($eCEquipmentTotal) && !(is_float($eCEquipmentTotal) || is_numeric($eCEquipmentTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($eCEquipmentTotal, true), gettype($eCEquipmentTotal)), __LINE__);
        }
        if (is_null($eCEquipmentTotal) || (is_array($eCEquipmentTotal) && empty($eCEquipmentTotal))) {
            unset($this->ECEquipmentTotal);
        } else {
            $this->ECEquipmentTotal = $eCEquipmentTotal;
        }
        return $this;
    }
    /**
     * Get ECFinancePartner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECFinancePartner()
    {
        return isset($this->ECFinancePartner) ? $this->ECFinancePartner : null;
    }
    /**
     * Set ECFinancePartner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCFinancePartner
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECFinancePartner($eCFinancePartner = null)
    {
        // validation for constraint: string
        if (!is_null($eCFinancePartner) && !is_string($eCFinancePartner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCFinancePartner, true), gettype($eCFinancePartner)), __LINE__);
        }
        if (is_null($eCFinancePartner) || (is_array($eCFinancePartner) && empty($eCFinancePartner))) {
            unset($this->ECFinancePartner);
        } else {
            $this->ECFinancePartner = $eCFinancePartner;
        }
        return $this;
    }
    /**
     * Get ECFinancePaymentCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getECFinancePaymentCount()
    {
        return isset($this->ECFinancePaymentCount) ? $this->ECFinancePaymentCount : null;
    }
    /**
     * Set ECFinancePaymentCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $eCFinancePaymentCount
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECFinancePaymentCount($eCFinancePaymentCount = null)
    {
        // validation for constraint: int
        if (!is_null($eCFinancePaymentCount) && !(is_int($eCFinancePaymentCount) || ctype_digit($eCFinancePaymentCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eCFinancePaymentCount, true), gettype($eCFinancePaymentCount)), __LINE__);
        }
        if (is_null($eCFinancePaymentCount) || (is_array($eCFinancePaymentCount) && empty($eCFinancePaymentCount))) {
            unset($this->ECFinancePaymentCount);
        } else {
            $this->ECFinancePaymentCount = $eCFinancePaymentCount;
        }
        return $this;
    }
    /**
     * Get ECGuardAddendum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getECGuardAddendum()
    {
        return isset($this->ECGuardAddendum) ? $this->ECGuardAddendum : null;
    }
    /**
     * Set ECGuardAddendum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $eCGuardAddendum
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECGuardAddendum($eCGuardAddendum = null)
    {
        // validation for constraint: boolean
        if (!is_null($eCGuardAddendum) && !is_bool($eCGuardAddendum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($eCGuardAddendum, true), gettype($eCGuardAddendum)), __LINE__);
        }
        if (is_null($eCGuardAddendum) || (is_array($eCGuardAddendum) && empty($eCGuardAddendum))) {
            unset($this->ECGuardAddendum);
        } else {
            $this->ECGuardAddendum = $eCGuardAddendum;
        }
        return $this;
    }
    /**
     * Get ECHomeOwner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getECHomeOwner()
    {
        return isset($this->ECHomeOwner) ? $this->ECHomeOwner : null;
    }
    /**
     * Set ECHomeOwner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $eCHomeOwner
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECHomeOwner($eCHomeOwner = null)
    {
        // validation for constraint: boolean
        if (!is_null($eCHomeOwner) && !is_bool($eCHomeOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($eCHomeOwner, true), gettype($eCHomeOwner)), __LINE__);
        }
        if (is_null($eCHomeOwner) || (is_array($eCHomeOwner) && empty($eCHomeOwner))) {
            unset($this->ECHomeOwner);
        } else {
            $this->ECHomeOwner = $eCHomeOwner;
        }
        return $this;
    }
    /**
     * Get ECInstallationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECInstallationDate()
    {
        return isset($this->ECInstallationDate) ? $this->ECInstallationDate : null;
    }
    /**
     * Set ECInstallationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCInstallationDate
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECInstallationDate($eCInstallationDate = null)
    {
        // validation for constraint: string
        if (!is_null($eCInstallationDate) && !is_string($eCInstallationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCInstallationDate, true), gettype($eCInstallationDate)), __LINE__);
        }
        if (is_null($eCInstallationDate) || (is_array($eCInstallationDate) && empty($eCInstallationDate))) {
            unset($this->ECInstallationDate);
        } else {
            $this->ECInstallationDate = $eCInstallationDate;
        }
        return $this;
    }
    /**
     * Get ECIsFinanced value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getECIsFinanced()
    {
        return isset($this->ECIsFinanced) ? $this->ECIsFinanced : null;
    }
    /**
     * Set ECIsFinanced value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $eCIsFinanced
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECIsFinanced($eCIsFinanced = null)
    {
        // validation for constraint: boolean
        if (!is_null($eCIsFinanced) && !is_bool($eCIsFinanced)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($eCIsFinanced, true), gettype($eCIsFinanced)), __LINE__);
        }
        if (is_null($eCIsFinanced) || (is_array($eCIsFinanced) && empty($eCIsFinanced))) {
            unset($this->ECIsFinanced);
        } else {
            $this->ECIsFinanced = $eCIsFinanced;
        }
        return $this;
    }
    /**
     * Get ECMonthPaidUpFront value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getECMonthPaidUpFront()
    {
        return isset($this->ECMonthPaidUpFront) ? $this->ECMonthPaidUpFront : null;
    }
    /**
     * Set ECMonthPaidUpFront value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $eCMonthPaidUpFront
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECMonthPaidUpFront($eCMonthPaidUpFront = null)
    {
        // validation for constraint: int
        if (!is_null($eCMonthPaidUpFront) && !(is_int($eCMonthPaidUpFront) || ctype_digit($eCMonthPaidUpFront))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eCMonthPaidUpFront, true), gettype($eCMonthPaidUpFront)), __LINE__);
        }
        if (is_null($eCMonthPaidUpFront) || (is_array($eCMonthPaidUpFront) && empty($eCMonthPaidUpFront))) {
            unset($this->ECMonthPaidUpFront);
        } else {
            $this->ECMonthPaidUpFront = $eCMonthPaidUpFront;
        }
        return $this;
    }
    /**
     * Get ECNOCDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECNOCDate()
    {
        return isset($this->ECNOCDate) ? $this->ECNOCDate : null;
    }
    /**
     * Set ECNOCDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCNOCDate
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECNOCDate($eCNOCDate = null)
    {
        // validation for constraint: string
        if (!is_null($eCNOCDate) && !is_string($eCNOCDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCNOCDate, true), gettype($eCNOCDate)), __LINE__);
        }
        if (is_null($eCNOCDate) || (is_array($eCNOCDate) && empty($eCNOCDate))) {
            unset($this->ECNOCDate);
        } else {
            $this->ECNOCDate = $eCNOCDate;
        }
        return $this;
    }
    /**
     * Get ECNewConstruction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getECNewConstruction()
    {
        return isset($this->ECNewConstruction) ? $this->ECNewConstruction : null;
    }
    /**
     * Set ECNewConstruction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $eCNewConstruction
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECNewConstruction($eCNewConstruction = null)
    {
        // validation for constraint: boolean
        if (!is_null($eCNewConstruction) && !is_bool($eCNewConstruction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($eCNewConstruction, true), gettype($eCNewConstruction)), __LINE__);
        }
        if (is_null($eCNewConstruction) || (is_array($eCNewConstruction) && empty($eCNewConstruction))) {
            unset($this->ECNewConstruction);
        } else {
            $this->ECNewConstruction = $eCNewConstruction;
        }
        return $this;
    }
    /**
     * Get ECOtherAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getECOtherAmount()
    {
        return isset($this->ECOtherAmount) ? $this->ECOtherAmount : null;
    }
    /**
     * Set ECOtherAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $eCOtherAmount
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECOtherAmount($eCOtherAmount = null)
    {
        // validation for constraint: float
        if (!is_null($eCOtherAmount) && !(is_float($eCOtherAmount) || is_numeric($eCOtherAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($eCOtherAmount, true), gettype($eCOtherAmount)), __LINE__);
        }
        if (is_null($eCOtherAmount) || (is_array($eCOtherAmount) && empty($eCOtherAmount))) {
            unset($this->ECOtherAmount);
        } else {
            $this->ECOtherAmount = $eCOtherAmount;
        }
        return $this;
    }
    /**
     * Get ECPartnerProgramDiscountAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getECPartnerProgramDiscountAmount()
    {
        return isset($this->ECPartnerProgramDiscountAmount) ? $this->ECPartnerProgramDiscountAmount : null;
    }
    /**
     * Set ECPartnerProgramDiscountAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $eCPartnerProgramDiscountAmount
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECPartnerProgramDiscountAmount($eCPartnerProgramDiscountAmount = null)
    {
        // validation for constraint: float
        if (!is_null($eCPartnerProgramDiscountAmount) && !(is_float($eCPartnerProgramDiscountAmount) || is_numeric($eCPartnerProgramDiscountAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($eCPartnerProgramDiscountAmount, true), gettype($eCPartnerProgramDiscountAmount)), __LINE__);
        }
        if (is_null($eCPartnerProgramDiscountAmount) || (is_array($eCPartnerProgramDiscountAmount) && empty($eCPartnerProgramDiscountAmount))) {
            unset($this->ECPartnerProgramDiscountAmount);
        } else {
            $this->ECPartnerProgramDiscountAmount = $eCPartnerProgramDiscountAmount;
        }
        return $this;
    }
    /**
     * Get ECPartnerProgramID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getECPartnerProgramID()
    {
        return isset($this->ECPartnerProgramID) ? $this->ECPartnerProgramID : null;
    }
    /**
     * Set ECPartnerProgramID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $eCPartnerProgramID
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECPartnerProgramID($eCPartnerProgramID = null)
    {
        // validation for constraint: int
        if (!is_null($eCPartnerProgramID) && !(is_int($eCPartnerProgramID) || ctype_digit($eCPartnerProgramID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eCPartnerProgramID, true), gettype($eCPartnerProgramID)), __LINE__);
        }
        if (is_null($eCPartnerProgramID) || (is_array($eCPartnerProgramID) && empty($eCPartnerProgramID))) {
            unset($this->ECPartnerProgramID);
        } else {
            $this->ECPartnerProgramID = $eCPartnerProgramID;
        }
        return $this;
    }
    /**
     * Get ECPartnerProgramMemberID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECPartnerProgramMemberID()
    {
        return isset($this->ECPartnerProgramMemberID) ? $this->ECPartnerProgramMemberID : null;
    }
    /**
     * Set ECPartnerProgramMemberID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCPartnerProgramMemberID
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECPartnerProgramMemberID($eCPartnerProgramMemberID = null)
    {
        // validation for constraint: string
        if (!is_null($eCPartnerProgramMemberID) && !is_string($eCPartnerProgramMemberID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCPartnerProgramMemberID, true), gettype($eCPartnerProgramMemberID)), __LINE__);
        }
        if (is_null($eCPartnerProgramMemberID) || (is_array($eCPartnerProgramMemberID) && empty($eCPartnerProgramMemberID))) {
            unset($this->ECPartnerProgramMemberID);
        } else {
            $this->ECPartnerProgramMemberID = $eCPartnerProgramMemberID;
        }
        return $this;
    }
    /**
     * Get ECPaymentCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getECPaymentCount()
    {
        return isset($this->ECPaymentCount) ? $this->ECPaymentCount : null;
    }
    /**
     * Set ECPaymentCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $eCPaymentCount
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECPaymentCount($eCPaymentCount = null)
    {
        // validation for constraint: int
        if (!is_null($eCPaymentCount) && !(is_int($eCPaymentCount) || ctype_digit($eCPaymentCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eCPaymentCount, true), gettype($eCPaymentCount)), __LINE__);
        }
        if (is_null($eCPaymentCount) || (is_array($eCPaymentCount) && empty($eCPaymentCount))) {
            unset($this->ECPaymentCount);
        } else {
            $this->ECPaymentCount = $eCPaymentCount;
        }
        return $this;
    }
    /**
     * Get ECPaymentExtendedServiceOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getECPaymentExtendedServiceOption()
    {
        return isset($this->ECPaymentExtendedServiceOption) ? $this->ECPaymentExtendedServiceOption : null;
    }
    /**
     * Set ECPaymentExtendedServiceOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $eCPaymentExtendedServiceOption
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECPaymentExtendedServiceOption($eCPaymentExtendedServiceOption = null)
    {
        // validation for constraint: boolean
        if (!is_null($eCPaymentExtendedServiceOption) && !is_bool($eCPaymentExtendedServiceOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($eCPaymentExtendedServiceOption, true), gettype($eCPaymentExtendedServiceOption)), __LINE__);
        }
        if (is_null($eCPaymentExtendedServiceOption) || (is_array($eCPaymentExtendedServiceOption) && empty($eCPaymentExtendedServiceOption))) {
            unset($this->ECPaymentExtendedServiceOption);
        } else {
            $this->ECPaymentExtendedServiceOption = $eCPaymentExtendedServiceOption;
        }
        return $this;
    }
    /**
     * Get ECPaymentMonthlyEquipmentAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getECPaymentMonthlyEquipmentAmount()
    {
        return isset($this->ECPaymentMonthlyEquipmentAmount) ? $this->ECPaymentMonthlyEquipmentAmount : null;
    }
    /**
     * Set ECPaymentMonthlyEquipmentAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $eCPaymentMonthlyEquipmentAmount
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECPaymentMonthlyEquipmentAmount($eCPaymentMonthlyEquipmentAmount = null)
    {
        // validation for constraint: float
        if (!is_null($eCPaymentMonthlyEquipmentAmount) && !(is_float($eCPaymentMonthlyEquipmentAmount) || is_numeric($eCPaymentMonthlyEquipmentAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($eCPaymentMonthlyEquipmentAmount, true), gettype($eCPaymentMonthlyEquipmentAmount)), __LINE__);
        }
        if (is_null($eCPaymentMonthlyEquipmentAmount) || (is_array($eCPaymentMonthlyEquipmentAmount) && empty($eCPaymentMonthlyEquipmentAmount))) {
            unset($this->ECPaymentMonthlyEquipmentAmount);
        } else {
            $this->ECPaymentMonthlyEquipmentAmount = $eCPaymentMonthlyEquipmentAmount;
        }
        return $this;
    }
    /**
     * Get ECPaymentMonthlyEquipmentSplitRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECPaymentMonthlyEquipmentSplitRate()
    {
        return isset($this->ECPaymentMonthlyEquipmentSplitRate) ? $this->ECPaymentMonthlyEquipmentSplitRate : null;
    }
    /**
     * Set ECPaymentMonthlyEquipmentSplitRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCPaymentMonthlyEquipmentSplitRate
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECPaymentMonthlyEquipmentSplitRate($eCPaymentMonthlyEquipmentSplitRate = null)
    {
        // validation for constraint: string
        if (!is_null($eCPaymentMonthlyEquipmentSplitRate) && !is_string($eCPaymentMonthlyEquipmentSplitRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCPaymentMonthlyEquipmentSplitRate, true), gettype($eCPaymentMonthlyEquipmentSplitRate)), __LINE__);
        }
        if (is_null($eCPaymentMonthlyEquipmentSplitRate) || (is_array($eCPaymentMonthlyEquipmentSplitRate) && empty($eCPaymentMonthlyEquipmentSplitRate))) {
            unset($this->ECPaymentMonthlyEquipmentSplitRate);
        } else {
            $this->ECPaymentMonthlyEquipmentSplitRate = $eCPaymentMonthlyEquipmentSplitRate;
        }
        return $this;
    }
    /**
     * Get ECPermitAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getECPermitAmount()
    {
        return isset($this->ECPermitAmount) ? $this->ECPermitAmount : null;
    }
    /**
     * Set ECPermitAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $eCPermitAmount
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECPermitAmount($eCPermitAmount = null)
    {
        // validation for constraint: float
        if (!is_null($eCPermitAmount) && !(is_float($eCPermitAmount) || is_numeric($eCPermitAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($eCPermitAmount, true), gettype($eCPermitAmount)), __LINE__);
        }
        if (is_null($eCPermitAmount) || (is_array($eCPermitAmount) && empty($eCPermitAmount))) {
            unset($this->ECPermitAmount);
        } else {
            $this->ECPermitAmount = $eCPermitAmount;
        }
        return $this;
    }
    /**
     * Get ECPrimaryEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECPrimaryEmail()
    {
        return isset($this->ECPrimaryEmail) ? $this->ECPrimaryEmail : null;
    }
    /**
     * Set ECPrimaryEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCPrimaryEmail
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECPrimaryEmail($eCPrimaryEmail = null)
    {
        // validation for constraint: string
        if (!is_null($eCPrimaryEmail) && !is_string($eCPrimaryEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCPrimaryEmail, true), gettype($eCPrimaryEmail)), __LINE__);
        }
        if (is_null($eCPrimaryEmail) || (is_array($eCPrimaryEmail) && empty($eCPrimaryEmail))) {
            unset($this->ECPrimaryEmail);
        } else {
            $this->ECPrimaryEmail = $eCPrimaryEmail;
        }
        return $this;
    }
    /**
     * Get ECPrimaryFirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECPrimaryFirstName()
    {
        return isset($this->ECPrimaryFirstName) ? $this->ECPrimaryFirstName : null;
    }
    /**
     * Set ECPrimaryFirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCPrimaryFirstName
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECPrimaryFirstName($eCPrimaryFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($eCPrimaryFirstName) && !is_string($eCPrimaryFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCPrimaryFirstName, true), gettype($eCPrimaryFirstName)), __LINE__);
        }
        if (is_null($eCPrimaryFirstName) || (is_array($eCPrimaryFirstName) && empty($eCPrimaryFirstName))) {
            unset($this->ECPrimaryFirstName);
        } else {
            $this->ECPrimaryFirstName = $eCPrimaryFirstName;
        }
        return $this;
    }
    /**
     * Get ECPrimaryLastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECPrimaryLastName()
    {
        return isset($this->ECPrimaryLastName) ? $this->ECPrimaryLastName : null;
    }
    /**
     * Set ECPrimaryLastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCPrimaryLastName
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECPrimaryLastName($eCPrimaryLastName = null)
    {
        // validation for constraint: string
        if (!is_null($eCPrimaryLastName) && !is_string($eCPrimaryLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCPrimaryLastName, true), gettype($eCPrimaryLastName)), __LINE__);
        }
        if (is_null($eCPrimaryLastName) || (is_array($eCPrimaryLastName) && empty($eCPrimaryLastName))) {
            unset($this->ECPrimaryLastName);
        } else {
            $this->ECPrimaryLastName = $eCPrimaryLastName;
        }
        return $this;
    }
    /**
     * Get ECPrimaryPhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECPrimaryPhone()
    {
        return isset($this->ECPrimaryPhone) ? $this->ECPrimaryPhone : null;
    }
    /**
     * Set ECPrimaryPhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCPrimaryPhone
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECPrimaryPhone($eCPrimaryPhone = null)
    {
        // validation for constraint: string
        if (!is_null($eCPrimaryPhone) && !is_string($eCPrimaryPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCPrimaryPhone, true), gettype($eCPrimaryPhone)), __LINE__);
        }
        if (is_null($eCPrimaryPhone) || (is_array($eCPrimaryPhone) && empty($eCPrimaryPhone))) {
            unset($this->ECPrimaryPhone);
        } else {
            $this->ECPrimaryPhone = $eCPrimaryPhone;
        }
        return $this;
    }
    /**
     * Get ECPromotionPeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getECPromotionPeriod()
    {
        return isset($this->ECPromotionPeriod) ? $this->ECPromotionPeriod : null;
    }
    /**
     * Set ECPromotionPeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $eCPromotionPeriod
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECPromotionPeriod($eCPromotionPeriod = null)
    {
        // validation for constraint: int
        if (!is_null($eCPromotionPeriod) && !(is_int($eCPromotionPeriod) || ctype_digit($eCPromotionPeriod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eCPromotionPeriod, true), gettype($eCPromotionPeriod)), __LINE__);
        }
        if (is_null($eCPromotionPeriod) || (is_array($eCPromotionPeriod) && empty($eCPromotionPeriod))) {
            unset($this->ECPromotionPeriod);
        } else {
            $this->ECPromotionPeriod = $eCPromotionPeriod;
        }
        return $this;
    }
    /**
     * Get ECRMR value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getECRMR()
    {
        return isset($this->ECRMR) ? $this->ECRMR : null;
    }
    /**
     * Set ECRMR value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $eCRMR
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECRMR($eCRMR = null)
    {
        // validation for constraint: float
        if (!is_null($eCRMR) && !(is_float($eCRMR) || is_numeric($eCRMR))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($eCRMR, true), gettype($eCRMR)), __LINE__);
        }
        if (is_null($eCRMR) || (is_array($eCRMR) && empty($eCRMR))) {
            unset($this->ECRMR);
        } else {
            $this->ECRMR = $eCRMR;
        }
        return $this;
    }
    /**
     * Get ECSalesperson value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECSalesperson()
    {
        return isset($this->ECSalesperson) ? $this->ECSalesperson : null;
    }
    /**
     * Set ECSalesperson value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCSalesperson
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECSalesperson($eCSalesperson = null)
    {
        // validation for constraint: string
        if (!is_null($eCSalesperson) && !is_string($eCSalesperson)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCSalesperson, true), gettype($eCSalesperson)), __LINE__);
        }
        if (is_null($eCSalesperson) || (is_array($eCSalesperson) && empty($eCSalesperson))) {
            unset($this->ECSalesperson);
        } else {
            $this->ECSalesperson = $eCSalesperson;
        }
        return $this;
    }
    /**
     * Get ECSecondaryEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECSecondaryEmail()
    {
        return isset($this->ECSecondaryEmail) ? $this->ECSecondaryEmail : null;
    }
    /**
     * Set ECSecondaryEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCSecondaryEmail
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECSecondaryEmail($eCSecondaryEmail = null)
    {
        // validation for constraint: string
        if (!is_null($eCSecondaryEmail) && !is_string($eCSecondaryEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCSecondaryEmail, true), gettype($eCSecondaryEmail)), __LINE__);
        }
        if (is_null($eCSecondaryEmail) || (is_array($eCSecondaryEmail) && empty($eCSecondaryEmail))) {
            unset($this->ECSecondaryEmail);
        } else {
            $this->ECSecondaryEmail = $eCSecondaryEmail;
        }
        return $this;
    }
    /**
     * Get ECSecondaryFirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECSecondaryFirstName()
    {
        return isset($this->ECSecondaryFirstName) ? $this->ECSecondaryFirstName : null;
    }
    /**
     * Set ECSecondaryFirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCSecondaryFirstName
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECSecondaryFirstName($eCSecondaryFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($eCSecondaryFirstName) && !is_string($eCSecondaryFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCSecondaryFirstName, true), gettype($eCSecondaryFirstName)), __LINE__);
        }
        if (is_null($eCSecondaryFirstName) || (is_array($eCSecondaryFirstName) && empty($eCSecondaryFirstName))) {
            unset($this->ECSecondaryFirstName);
        } else {
            $this->ECSecondaryFirstName = $eCSecondaryFirstName;
        }
        return $this;
    }
    /**
     * Get ECSecondaryLastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECSecondaryLastName()
    {
        return isset($this->ECSecondaryLastName) ? $this->ECSecondaryLastName : null;
    }
    /**
     * Set ECSecondaryLastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCSecondaryLastName
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECSecondaryLastName($eCSecondaryLastName = null)
    {
        // validation for constraint: string
        if (!is_null($eCSecondaryLastName) && !is_string($eCSecondaryLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCSecondaryLastName, true), gettype($eCSecondaryLastName)), __LINE__);
        }
        if (is_null($eCSecondaryLastName) || (is_array($eCSecondaryLastName) && empty($eCSecondaryLastName))) {
            unset($this->ECSecondaryLastName);
        } else {
            $this->ECSecondaryLastName = $eCSecondaryLastName;
        }
        return $this;
    }
    /**
     * Get ECSecondaryPhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECSecondaryPhone()
    {
        return isset($this->ECSecondaryPhone) ? $this->ECSecondaryPhone : null;
    }
    /**
     * Set ECSecondaryPhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCSecondaryPhone
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECSecondaryPhone($eCSecondaryPhone = null)
    {
        // validation for constraint: string
        if (!is_null($eCSecondaryPhone) && !is_string($eCSecondaryPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCSecondaryPhone, true), gettype($eCSecondaryPhone)), __LINE__);
        }
        if (is_null($eCSecondaryPhone) || (is_array($eCSecondaryPhone) && empty($eCSecondaryPhone))) {
            unset($this->ECSecondaryPhone);
        } else {
            $this->ECSecondaryPhone = $eCSecondaryPhone;
        }
        return $this;
    }
    /**
     * Get ECSiteAddress1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECSiteAddress1()
    {
        return isset($this->ECSiteAddress1) ? $this->ECSiteAddress1 : null;
    }
    /**
     * Set ECSiteAddress1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCSiteAddress1
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECSiteAddress1($eCSiteAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($eCSiteAddress1) && !is_string($eCSiteAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCSiteAddress1, true), gettype($eCSiteAddress1)), __LINE__);
        }
        if (is_null($eCSiteAddress1) || (is_array($eCSiteAddress1) && empty($eCSiteAddress1))) {
            unset($this->ECSiteAddress1);
        } else {
            $this->ECSiteAddress1 = $eCSiteAddress1;
        }
        return $this;
    }
    /**
     * Get ECSiteAddress2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECSiteAddress2()
    {
        return isset($this->ECSiteAddress2) ? $this->ECSiteAddress2 : null;
    }
    /**
     * Set ECSiteAddress2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCSiteAddress2
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECSiteAddress2($eCSiteAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($eCSiteAddress2) && !is_string($eCSiteAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCSiteAddress2, true), gettype($eCSiteAddress2)), __LINE__);
        }
        if (is_null($eCSiteAddress2) || (is_array($eCSiteAddress2) && empty($eCSiteAddress2))) {
            unset($this->ECSiteAddress2);
        } else {
            $this->ECSiteAddress2 = $eCSiteAddress2;
        }
        return $this;
    }
    /**
     * Get ECSiteCity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECSiteCity()
    {
        return isset($this->ECSiteCity) ? $this->ECSiteCity : null;
    }
    /**
     * Set ECSiteCity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCSiteCity
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECSiteCity($eCSiteCity = null)
    {
        // validation for constraint: string
        if (!is_null($eCSiteCity) && !is_string($eCSiteCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCSiteCity, true), gettype($eCSiteCity)), __LINE__);
        }
        if (is_null($eCSiteCity) || (is_array($eCSiteCity) && empty($eCSiteCity))) {
            unset($this->ECSiteCity);
        } else {
            $this->ECSiteCity = $eCSiteCity;
        }
        return $this;
    }
    /**
     * Get ECSiteState value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECSiteState()
    {
        return isset($this->ECSiteState) ? $this->ECSiteState : null;
    }
    /**
     * Set ECSiteState value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCSiteState
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECSiteState($eCSiteState = null)
    {
        // validation for constraint: string
        if (!is_null($eCSiteState) && !is_string($eCSiteState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCSiteState, true), gettype($eCSiteState)), __LINE__);
        }
        if (is_null($eCSiteState) || (is_array($eCSiteState) && empty($eCSiteState))) {
            unset($this->ECSiteState);
        } else {
            $this->ECSiteState = $eCSiteState;
        }
        return $this;
    }
    /**
     * Get ECSiteZip value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECSiteZip()
    {
        return isset($this->ECSiteZip) ? $this->ECSiteZip : null;
    }
    /**
     * Set ECSiteZip value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCSiteZip
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECSiteZip($eCSiteZip = null)
    {
        // validation for constraint: string
        if (!is_null($eCSiteZip) && !is_string($eCSiteZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCSiteZip, true), gettype($eCSiteZip)), __LINE__);
        }
        if (is_null($eCSiteZip) || (is_array($eCSiteZip) && empty($eCSiteZip))) {
            unset($this->ECSiteZip);
        } else {
            $this->ECSiteZip = $eCSiteZip;
        }
        return $this;
    }
    /**
     * Get ECTagAutoPay value
     * @return bool|null
     */
    public function getECTagAutoPay()
    {
        return $this->ECTagAutoPay;
    }
    /**
     * Set ECTagAutoPay value
     * @param bool $eCTagAutoPay
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECTagAutoPay($eCTagAutoPay = null)
    {
        // validation for constraint: boolean
        if (!is_null($eCTagAutoPay) && !is_bool($eCTagAutoPay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($eCTagAutoPay, true), gettype($eCTagAutoPay)), __LINE__);
        }
        $this->ECTagAutoPay = $eCTagAutoPay;
        return $this;
    }
    /**
     * Get ECTagCommercialDoc value
     * @return bool|null
     */
    public function getECTagCommercialDoc()
    {
        return $this->ECTagCommercialDoc;
    }
    /**
     * Set ECTagCommercialDoc value
     * @param bool $eCTagCommercialDoc
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECTagCommercialDoc($eCTagCommercialDoc = null)
    {
        // validation for constraint: boolean
        if (!is_null($eCTagCommercialDoc) && !is_bool($eCTagCommercialDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($eCTagCommercialDoc, true), gettype($eCTagCommercialDoc)), __LINE__);
        }
        $this->ECTagCommercialDoc = $eCTagCommercialDoc;
        return $this;
    }
    /**
     * Get ECTagHomeownerDoc value
     * @return bool|null
     */
    public function getECTagHomeownerDoc()
    {
        return $this->ECTagHomeownerDoc;
    }
    /**
     * Set ECTagHomeownerDoc value
     * @param bool $eCTagHomeownerDoc
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECTagHomeownerDoc($eCTagHomeownerDoc = null)
    {
        // validation for constraint: boolean
        if (!is_null($eCTagHomeownerDoc) && !is_bool($eCTagHomeownerDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($eCTagHomeownerDoc, true), gettype($eCTagHomeownerDoc)), __LINE__);
        }
        $this->ECTagHomeownerDoc = $eCTagHomeownerDoc;
        return $this;
    }
    /**
     * Get ECTagProofOfPay value
     * @return bool|null
     */
    public function getECTagProofOfPay()
    {
        return $this->ECTagProofOfPay;
    }
    /**
     * Set ECTagProofOfPay value
     * @param bool $eCTagProofOfPay
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECTagProofOfPay($eCTagProofOfPay = null)
    {
        // validation for constraint: boolean
        if (!is_null($eCTagProofOfPay) && !is_bool($eCTagProofOfPay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($eCTagProofOfPay, true), gettype($eCTagProofOfPay)), __LINE__);
        }
        $this->ECTagProofOfPay = $eCTagProofOfPay;
        return $this;
    }
    /**
     * Get ECTagStoreFront value
     * @return bool|null
     */
    public function getECTagStoreFront()
    {
        return $this->ECTagStoreFront;
    }
    /**
     * Set ECTagStoreFront value
     * @param bool $eCTagStoreFront
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECTagStoreFront($eCTagStoreFront = null)
    {
        // validation for constraint: boolean
        if (!is_null($eCTagStoreFront) && !is_bool($eCTagStoreFront)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($eCTagStoreFront, true), gettype($eCTagStoreFront)), __LINE__);
        }
        $this->ECTagStoreFront = $eCTagStoreFront;
        return $this;
    }
    /**
     * Get ECTaxAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getECTaxAmount()
    {
        return isset($this->ECTaxAmount) ? $this->ECTaxAmount : null;
    }
    /**
     * Set ECTaxAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $eCTaxAmount
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECTaxAmount($eCTaxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($eCTaxAmount) && !(is_float($eCTaxAmount) || is_numeric($eCTaxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($eCTaxAmount, true), gettype($eCTaxAmount)), __LINE__);
        }
        if (is_null($eCTaxAmount) || (is_array($eCTaxAmount) && empty($eCTaxAmount))) {
            unset($this->ECTaxAmount);
        } else {
            $this->ECTaxAmount = $eCTaxAmount;
        }
        return $this;
    }
    /**
     * Get ECVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECVersion()
    {
        return isset($this->ECVersion) ? $this->ECVersion : null;
    }
    /**
     * Set ECVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCVersion
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setECVersion($eCVersion = null)
    {
        // validation for constraint: string
        if (!is_null($eCVersion) && !is_string($eCVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCVersion, true), gettype($eCVersion)), __LINE__);
        }
        if (is_null($eCVersion) || (is_array($eCVersion) && empty($eCVersion))) {
            unset($this->ECVersion);
        } else {
            $this->ECVersion = $eCVersion;
        }
        return $this;
    }
    /**
     * Get ExtendedServicePlanMonthlyAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getExtendedServicePlanMonthlyAmount()
    {
        return isset($this->ExtendedServicePlanMonthlyAmount) ? $this->ExtendedServicePlanMonthlyAmount : null;
    }
    /**
     * Set ExtendedServicePlanMonthlyAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $extendedServicePlanMonthlyAmount
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setExtendedServicePlanMonthlyAmount($extendedServicePlanMonthlyAmount = null)
    {
        // validation for constraint: float
        if (!is_null($extendedServicePlanMonthlyAmount) && !(is_float($extendedServicePlanMonthlyAmount) || is_numeric($extendedServicePlanMonthlyAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($extendedServicePlanMonthlyAmount, true), gettype($extendedServicePlanMonthlyAmount)), __LINE__);
        }
        if (is_null($extendedServicePlanMonthlyAmount) || (is_array($extendedServicePlanMonthlyAmount) && empty($extendedServicePlanMonthlyAmount))) {
            unset($this->ExtendedServicePlanMonthlyAmount);
        } else {
            $this->ExtendedServicePlanMonthlyAmount = $extendedServicePlanMonthlyAmount;
        }
        return $this;
    }
    /**
     * Get HasExtendedServicePlan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasExtendedServicePlan()
    {
        return isset($this->HasExtendedServicePlan) ? $this->HasExtendedServicePlan : null;
    }
    /**
     * Set HasExtendedServicePlan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasExtendedServicePlan
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setHasExtendedServicePlan($hasExtendedServicePlan = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasExtendedServicePlan) && !is_bool($hasExtendedServicePlan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasExtendedServicePlan, true), gettype($hasExtendedServicePlan)), __LINE__);
        }
        if (is_null($hasExtendedServicePlan) || (is_array($hasExtendedServicePlan) && empty($hasExtendedServicePlan))) {
            unset($this->HasExtendedServicePlan);
        } else {
            $this->HasExtendedServicePlan = $hasExtendedServicePlan;
        }
        return $this;
    }
    /**
     * Get PrivateData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \MoniFunding\StructType\CommonFundingDataPrivateObject|null
     */
    public function getPrivateData()
    {
        return isset($this->PrivateData) ? $this->PrivateData : null;
    }
    /**
     * Set PrivateData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \MoniFunding\StructType\CommonFundingDataPrivateObject $privateData
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setPrivateData(\MoniFunding\StructType\CommonFundingDataPrivateObject $privateData = null)
    {
        if (is_null($privateData) || (is_array($privateData) && empty($privateData))) {
            unset($this->PrivateData);
        } else {
            $this->PrivateData = $privateData;
        }
        return $this;
    }
    /**
     * Get StatusCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatusCode()
    {
        return isset($this->StatusCode) ? $this->StatusCode : null;
    }
    /**
     * Set StatusCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $statusCode
     * @return \MoniFunding\StructType\CommonFundingDataObject
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        if (is_null($statusCode) || (is_array($statusCode) && empty($statusCode))) {
            unset($this->StatusCode);
        } else {
            $this->StatusCode = $statusCode;
        }
        return $this;
    }
}
