<?php

namespace MoniFunding\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Upsert ServiceType
 * @subpackage Services
 */
class Upsert extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * UpsertCommonFundingDataFromCustomerAdmin
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MoniFunding\StructType\UpsertCommonFundingDataFromCustomerAdmin $parameters
     * @return \MoniFunding\StructType\UpsertCommonFundingDataFromCustomerAdminResponse|bool
     */
    public function UpsertCommonFundingDataFromCustomerAdmin(\MoniFunding\StructType\UpsertCommonFundingDataFromCustomerAdmin $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpsertCommonFundingDataFromCustomerAdmin($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * UpsertCommonFundingDataFromEcontract
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MoniFunding\StructType\UpsertCommonFundingDataFromEcontract $parameters
     * @return \MoniFunding\StructType\UpsertCommonFundingDataFromEcontractResponse|bool
     */
    public function UpsertCommonFundingDataFromEcontract(\MoniFunding\StructType\UpsertCommonFundingDataFromEcontract $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpsertCommonFundingDataFromEcontract($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * UpsertCommonFundingDataFromThirdPartyCRM
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MoniFunding\StructType\UpsertCommonFundingDataFromThirdPartyCRM $parameters
     * @return \MoniFunding\StructType\UpsertCommonFundingDataFromThirdPartyCRMResponse|bool
     */
    public function UpsertCommonFundingDataFromThirdPartyCRM(\MoniFunding\StructType\UpsertCommonFundingDataFromThirdPartyCRM $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpsertCommonFundingDataFromThirdPartyCRM($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \MoniFunding\StructType\UpsertCommonFundingDataFromCustomerAdminResponse|\MoniFunding\StructType\UpsertCommonFundingDataFromEcontractResponse|\MoniFunding\StructType\UpsertCommonFundingDataFromThirdPartyCRMResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
