<?php

namespace MoniFunding\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for APIV ServiceType
 * @subpackage Services
 */
class APIV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named APIVersion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MoniFunding\StructType\APIVersion $parameters
     * @return \MoniFunding\StructType\APIVersionResponse|bool
     */
    public function APIVersion(\MoniFunding\StructType\APIVersion $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->APIVersion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \MoniFunding\StructType\APIVersionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
